/*
 * Type.java
 * 
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.besp.model.fmfw;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.ModelException;

/**
 * Agent,Goods,Information,AbstractBehavior,Relation̎ނ\߂̐eNXłB
 * ʊTOƂĂ̐eType𕡐AʊTOƂĂ̎qType𕡐Ƃł܂B
 * A̐eq֌W̃[v\z邱Ƃ͂ł܂B
 * fɑ݂Type͑SVocabularyNXɂĊǗĂ悤ɂĂB
 * iڍׂVocabularyNXQ
 * 
 * @author Mizutori
 * @version $Id: Type.java,v 1.1 2004/03/21 12:07:47 macchan Exp $
 */
public abstract class Type implements Information {

	private static final long serialVersionUID = 1L;
	private static final Logger logger = Logger.getLogger(Type.class.getName());

	private String name = null; // ̃^Cv̖OłB

	private List parents = new ArrayList(); // eTypẽXgłB
	private List children = new ArrayList(); // qTypẽXgłB

	/**
	 * RXgN^łBType̖Oɗ^ĂB
	 * @param name@Type̖O
	 */
	public Type(String name) {
		this.name = name;
		rehash();
	}

	/**
	 * q^Cvǉ܂D
	 * @param child@ǉTypeD
	 */
	public void addChild(Type child) {
		logger.debug("IN");
		//e^Cvq^Cvɓo^悤ƂꍇExceptionȂD
		List list = this.getParentsRecursively();
		if (list.contains(child)) {
			throw new ModelException(
				"This type is already registered as parent type: " + child);
		}
		//q^Cve^Cvɓo^悤ƂꍇExceptionȂD
		list = child.getChildrenRecursively();
		if (list.contains(this)) {
			logger.debug("OUT(Exception)");
			throw new ModelException(
				"This type is already registered as parent type: " + child);
		}
		child.parents.add(this);
		this.children.add(child);

		rehash();
		logger.debug("OUT");
	}

	/**
	 * q^Cv폜܂D
	 * @param target@폜Type
	 */
	public void removeChild(Type child) {
		logger.debug("IN");
		assert children.contains(child);
		child.parents.remove(this);
		this.children.remove(child);

		rehash();
		logger.debug("OUT");
	}

	/**
	 * OԂ܂D.
	 * @return String@O̕
	 */
	public String getName() {
		return this.name;
	}

	/**
	 * ɑ݂q^CvListԂ܂D
	 * @return List@q^CvList
	 */
	public List getChildren() {
		return new ArrayList(children);
	}

	/**
	 * ʂɑ݂q^CvċAIɂׂĂƂ肾ListƂĕԂ܂D
	 * @return List@ׂẲʃ^CvList
	 * 2003/08/12 ̂ߏ܂ij
	 */

	// 2003/08/12O
	//	public List getChildrenRecursively() {
	//		logger.debug("IN");
	//		ArrayList value = new ArrayList(children);
	//		Iterator i = children.iterator();
	//		while (i.hasNext()) {
	//			Type child = (Type) i.next();
	//			value.addAll(child.getChildrenRecursively());
	//		}
	//		logger.debug("OUT");
	//		return value;
	//	}

	// 2003/08/12
	//	public List getChildrenRecursively() {
	//		List children = new ArrayList();	
	//		addChildren(children);
	//		return children;
	//	}
	//
	//	private void addChildren(List list) {
	//		list.add(this);
	//
	//		Iterator i = children.iterator();
	//		while (i.hasNext()) {
	//			Type child = (Type) i.next();
	//			child.addChildren(list);
	//		}
	//	}

	// 2003/08/122

	private List cashChildren = null;

	public List getChildrenRecursively() {
		return cashChildren;
	}

	private void rehash() {
		List parents = this.parents;
		Iterator i = parents.iterator();
		while (i.hasNext()) {
			Type type = (Type) i.next();
			type.rehashChildren();
		}
		rehashChildren();
	}

	private void rehashChildren() {
		this.cashChildren = getChildrenRecursivelyInternal();
		this.cashMapChildren = getMapChildrenRecursivelyInternal();
	}

	private List getChildrenRecursivelyInternal() {
		List children = new ArrayList();
		addChildren(children);
		return children;
	}

	private void addChildren(List list) {
		list.add(this);

		Iterator i = this.children.iterator();
		while (i.hasNext()) {
			Type child = (Type) i.next();
			child.addChildren(list);
		}
	}

	// 2003/08/122

	// List.contents͒x̂ŁAHashɕύX

	private Map cashMapChildren = null;

	private Map getMapChildrenRecursivelyInternal() {
		Map children = new TreeMap();
		addMapChildren(children);
		return children;
	}

	private void addMapChildren(Map map) {
		map.put(this.name, this);

		Iterator i = this.children.iterator();
		while (i.hasNext()) {
			Type child = (Type) i.next();
			child.addMapChildren(map);
		}
	}

	// 2003/08/12I	

	/**
	 * e^CvListԂ܂D.
	 * @return List e^CvList
	 */
	public List getParents() {
		return new ArrayList(parents);
	}

	/**
	 * ŗ^ꂽ^Cv̎q^Cvł邩ǂׂ悤ɃI[o[Ch܂
	 * @param type
	 * @return boolean
	 */
	public boolean equals(Type type) {
		if (this == type) {
			return true;
		}
		//List list = type.getChildrenRecursively();
		//return list.contains(this);
		Map map = type.cashMapChildren;
		return map.containsKey(this.name);
		//map̕2.2{ł
	}

	/**
	 * ʂɑ݂q^CvċAIɂׂĂƂ肾ListƂĕԂ܂D
	 * @return List@ׂẲʃ^CvList
	 */
	public List getParentsRecursively() {
		logger.debug("IN");
		ArrayList value = new ArrayList(parents);
		Iterator i = parents.iterator();
		while (i.hasNext()) {
			Type parent = (Type) i.next();
			value.addAll(parent.getParentsRecursively());
		}
		logger.debug("OUT");
		return value;

	}

	/**
	 * ^CṽIuWFNgƃNX𕶎ŕԂ܂D
	 * toStringI[o[Ch܂B
	 */
	public String toString() {
		return this.chopPackage(getClass().getName())
			+ " - \""
			+ this.getName()
			+ "\"";
	}

	/**
	 * pbP[W؂郆[eBeB[\bh
	 */
	private String chopPackage(String str) {
		return str.substring(str.lastIndexOf(".") + 1);
	}

}
