/*
 * TypeManager.java
 * 
 * Copyright (c) 2002 Boxed-Economy Project. All right reserved. 
 */
package org.boxed_economy.besp.model.fmfw;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import org.apache.log4j.Logger;

/**
 * WorldTypeǗNXłBworld̎Type̊Ǘ@\Ϗ܂B
 * MapɂTypȅWi[܂B
 * L[͔Cӂ̕łAw肵ȂꍇType̖OɂȂ܂B
 * bf̈ꕔƂłȂAfReiɏ邱Ƃ
 * f𒴂TOi^Cvj̊Ǘ\ɂ܂B
 * 
 * @author rx78g
 * @version $Id: TypeManager.java,v 1.1 2004/03/21 12:07:47 macchan Exp $
 */
public class TypeManager {

	private static final Logger logger =
		Logger.getLogger(TypeManager.class.getName());

	private Map agentTypes = new HashMap();
	private Map behaviorTypes = new HashMap();
	private Map goodsTypes = new HashMap();
	private Map informationTypes = new HashMap();
	private Map relationTypes = new HashMap();

	public TypeManager() {
	}

	/*********
	 * getter
	 *********/

	/**
	* L[ɊYAgentType擾܂B
	* ݂Ȃ΁AnullԂ܂B
	* @param key L[
	*/
	public AgentType getAgentType(String key) {
		return (AgentType) this.agentTypes.get(key);
	}

	/**
	* L[ɊYBehaviorType擾܂B
	* ݂Ȃ΁AnullԂ܂B
	* @param key L[
	*/
	public BehaviorType getBehaviorType(String key) {
		return (BehaviorType) this.behaviorTypes.get(key);
	}

	/**
	* L[ɊYGoodsType擾܂B
	* ݂Ȃ΁AnullԂ܂B
	* @param key L[
	*/
	public GoodsType getGoodsType(String key) {
		return (GoodsType) this.goodsTypes.get(key);
	}

	/**
	* L[ɊYInformationType擾܂B
	* ݂Ȃ΁AnullԂ܂B
	* @param key L[
	*/
	public InformationType getInformationType(String key) {
		return (InformationType) this.informationTypes.get(key);
	}

	/**
	* L[ɊYRelationType擾܂B
	* ݂Ȃ΁AnullԂ܂B
	* @param key L[
	*/
	public RelationType getRelationType(String key) {
		return (RelationType) this.relationTypes.get(key);
	}

	/************
	 * all getter
	 ************/

	/**
	 * SĂAgentTypeԂ܂B
	 */
	public Collection getAgentTypes() {
		return new ArrayList(this.agentTypes.values());
	}

	/**
	* SĂBehaviorTypeԂ܂B
	*/
	public Collection getBehaviorTypes() {
		return new ArrayList(this.behaviorTypes.values());
	}

	/**
	* SĂGoodsTypeԂ܂B
	*/
	public Collection getGoodsTypes() {
		return new ArrayList(this.goodsTypes.values());
	}

	/**
	* SĂInformationTypeԂ܂B
	*/
	public Collection getInformationTypes() {
		return new ArrayList(this.informationTypes.values());
	}

	/**
	* SĂRelationTypeԂ܂B
	*/
	public Collection getRelationTypes() {
		return new ArrayList(this.relationTypes.values());
	}

	/**
	 * AgentType쐬ĕԂ܂BType̍쐬ƓVocabularyɒǉ܂B
	 * @param name 쐬Type̖O
	 * @return AgentType 쐬ꂽType
	 */
	public AgentType installAgentType(String name) {
		if (this.agentTypes.containsKey(name)) {
			logger.info("already installed AgentType = " + name);
		}
		else {
			logger.info("install AgentType = " + name);
			this.agentTypes.put(name, new AgentType(name));
		}
		return (AgentType) this.agentTypes.get(name);
	}

	/**
	* GoodsType쐬ĕԂ܂BType̍쐬ƓVocabularyɒǉ܂B
	* @param name 쐬Type̖O
	* @return GoodsType 쐬ꂽType
	*/
	public GoodsType installGoodsType(String name) {
		if (this.goodsTypes.containsKey(name)) {
			logger.info("already installed GoodsType = " + name);
		}
		else {
			logger.info("install GoodsType = " + name);
			this.goodsTypes.put(name, new GoodsType(name));
		}
		return (GoodsType) this.goodsTypes.get(name);
	}

	/**
	* BehaviorType쐬ĕԂ܂BType̍쐬ƓVocabularyɒǉ܂B
	* @param name 쐬Type̖O
	* @return BehaviorType 쐬ꂽType
	*/
	public BehaviorType installBehaviorType(String name) {
		if (this.behaviorTypes.containsKey(name)) {
			logger.info("already installed BehaviorType = " + name);
		}
		else {
			logger.info("install BehaviorType = " + name);
			this.behaviorTypes.put(name, new BehaviorType(name));
		}
		return (BehaviorType) this.behaviorTypes.get(name);
	}

	/**
	* RelationType쐬ĕԂ܂BType̍쐬ƓVocabularyɒǉ܂B
	* @param name 쐬Type̖O
	* @return RelationType 쐬ꂽType
	*/
	public RelationType installRelationType(String name) {
		if (this.relationTypes.containsKey(name)) {
			logger.info("already installed RelationType = " + name);
		}
		else {
			logger.info("install RelationType = " + name);
			this.relationTypes.put(name, new RelationType(name));
		}
		return (RelationType) this.relationTypes.get(name);
	}

	/**
	* InformationType쐬ĕԂ܂BType̍쐬ƓVocabularyɒǉ܂B
	* @param name 쐬Type̖O
	* @return InformationType 쐬ꂽType
	*/
	public InformationType installInformationType(String name) {
		if (this.informationTypes.containsKey(name)) {
			logger.info("already installed InformationType = " + name);
		}
		else {
			logger.info("install InformationType = " + name);
			this.informationTypes.put(name, new InformationType(name));
		}
		return (InformationType) this.informationTypes.get(name);
	}
}
