/*
 * World.java
 * 
 * Copyright (c) 2002 Boxed-Economy Project. All right reserved. 
 */
package org.boxed_economy.besp.model.fmfw;

import java.util.Collection;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.ModelContainer;
import org.boxed_economy.besp.model.fmfw.update.UpdateWorldEvent;
import org.boxed_economy.besp.presentation.PresentationContainer;

/**
 * fɂworld`܂BWorld̖͈ȉ̒ʂłB
 *
 * PDworldAgentzuĊǗ܂B
 * QDWorldpNXɂăf`邱Ƃł܂B
 * @@iAgent̐EǉȂǂinit()I[o[ChċLq܂Bj
 * RDClock,SpaceێA擾ł܂BiWorld̎ԁEԂKj
 * SDASYiRandomNumberGeneratorjǗ܂B
 * TDVocaburalyNXʂāAModelTypeǗ܂B
 *
 *@ ̖AbfɂĎoσfWorld̓x[XƂȂvf
 * Ƃł܂B
 * 
 * ܂Â߂Ɉȉ̋@\܂B
 * 
 * WorldɃftHgsȂ܂BbfŒ`Ă@\ɉ
 * 
 * EUpdateModelEventzM邽߂ɁAPresentationContainer擾@\
 * E莞Ԏŝ߂LimitedRunSetting̊Ǘ
 * ETimeEvent̔zMǗ邽߂ɁAPriorityNXType֘At@\
 * 
 * @author macchan
 * @version $Id: World.java,v 1.3 2004/06/07 06:22:50 macchan Exp $
 */
public class World extends FmFwObject {

	private static final long serialVersionUID = 1L;
	private static final Logger logger =
		Logger.getLogger(World.class.getName());

	private transient ModelContainer modelContainer = null;

	private Clock clock = null;
	private Space space = null;

	private boolean initialized = false;
	private long defaultRandomSeed = 0;
	//WorldInitializerŕύXł悤ɃCX^XϐɂȂĂ
	private long timeEventRandomSeed = 0;

	private AgentManager agentManager = new AgentManager();
	private RandomNumberGeneratorManager randomManager =
		new RandomNumberGeneratorManager();

	/*********************************
	 *  
	 *********************************/

	/**
	 * ܂
	 */
	public final void initialize() {
		if (!this.initialized) {
			this.initializeWorld();
			this.initializeAgents();
			this.initialized = true;
		}
	}

	/**
	 * E܂
	 * (_, v, Ԃ̏z肵Ă܂)
	 */
	public void initializeWorld() {
		this.installRandomNumberGenerator(
			new DefaultRandomNumberGenerator(
				FMFWConstants.RANDOM_DEFAULT,
				this.defaultRandomSeed));
		this.installRandomNumberGenerator(
			new DefaultRandomNumberGenerator(
				FMFWConstants.RANDOM_TIMEEVENT,
				timeEventRandomSeed));
	}

	/**
	 * G[WFg܂
	 * (G[WFg, , ֌W̏z肵Ă܂)
	 */
	public void initializeAgents() {
	}

	/*********************************
	 *  O
	 *********************************/

	/**
	 * f̖OԂ܂B
	 * ftHg̎ł̓NXԂ܂B
	 * pfŃI[o[Ch邱ƂɂăNXȊO̖O𗘗pł܂B
	 */
	public String getName() {
		return this.getClass().getName();
	}

	/**
	 * f̐Ԃ܂D
	 */
	public String getDescription() {
		return getName();
	}

	/*********************************
	*  Container֘A
	*********************************/

	public void setModelContainer(ModelContainer container) {
		this.modelContainer = container;
	}

	public PresentationContainer getPresentationContainer() {
		if (modelContainer == null) {
			return null;
		}
		return this.modelContainer.getPresentationContainer();
	}

	public ModelContainer getModelContainer() {
		return modelContainer;
	}

	/*********************************
	 *  AgentǗ
	 *********************************/

	/**
	 * TypeAgentԂ܂BꍇAԍŏɒǉꂽAgentԂ܂B
	 * Ȃ΁AExceptionԂ܂B
	 * @param type w肷AgentType
	 * @return Agent YAgent
	 */
	public Agent getAgent(AgentType type) {
		return this.agentManager.getAgent(type);
	}

	/**	 
	 * TypeAgentCollectionԂ܂B
	 * Ȃ΁ACollectionԂ܂B
	 * @param type w肷AgentType
	 * @return Collection YAgent̏W
	 */
	public Collection getAgents(AgentType type) {
		return this.agentManager.getAgents(type);
	}

	/**
	 * Typeyт̎qTypeAgentCollectionԂ܂B
	 * Ȃ΁ACollectionԂ܂B
	 * @param type w肷AgentType
	 * @return Collection YAgent̏W
	 */
	public Collection getAgentsRecursively(AgentType type) {
		return this.agentManager.getAgentsRecursively(type);
	}

	/**
	 * SĂAgent̏WԂ܂B
	 * @return Collection Agent̏W
	 */
	public Collection getAllAgents() {
		return this.agentManager.getAllAgents();
	}

	/**
	 * ftHg̒萔𗘗păG[WFg𐶐܂B
	 * @return Agent ꂽAgent
	 */
	public Agent createAgent() {
		return this.createAgent(FMFWConstants.AGENTTYPE_DEFAULT);
	}

	/**
	 * G[WFg𐶐܂BAgentinit\bhĂт܂B
	 * @param type AgentType
	 * @return Agent ꂽAgent
	 */
	public Agent createAgent(AgentType type) {
		logger.debug("IN");

		Agent agent = new Agent(type);
		agent.setWorld(this);
		agent.initialize();
		this.agentManager.addAgent(agent);
		this.fireAgentCreated(new UpdateWorldEvent(this, agent));

		logger.debug("OUT");
		return agent;
	}

	/**
	 * WorldAgent폜܂BAgent̎SEłӖ܂B
	 * ݂ȂꍇAException𓊂܂B
	 * @param target 폜Agent
	 */
	public void destroyAgent(Agent agent) {
		logger.debug("IN");

		agent.receiveDeathEvent(agent);
		this.agentManager.removeAgent(agent);
		this.fireAgentDestroyed(new UpdateWorldEvent(this, agent));

		logger.debug("OUT");
	}

	/*********************************
	*  GoodsǉE폜
	*********************************/

	/**
	* ɊÂAGoods𐶐ĕԂ܂B
	* @param type GoodsɎw肷GoodsType
	* @param quality Goods̗
	* @return Goods ꂽGoods
	*/
	public Goods createGoods(GoodsType type, double quantity) {
		logger.debug("IN");

		Goods goods = new Goods(type, quantity);
		goods.setWorld(this);
		this.fireGoodsCreated(new UpdateWorldEvent(this, goods));

		logger.debug("OUT");
		return goods;
	}

	/**
	 * Goods邽߂ɖIɌĂԃ\bhłB
	 * @param goods
	 */
	public void consumeGoods(Goods goods) {
		this.fireGoodsConsumed(new UpdateWorldEvent(this, goods));
	}

	/*********************************
	*  Clock,SpaceǗ
	*********************************/

	/**
	* globalԂݒ肵܂B
	* @param clock ݒ肷鎞
	*/
	public void setClock(Clock clock) {
		this.clock = clock;
		clock.setWorld(this);
	}

	/**
	* WorldێClock擾܂B
	* @return clock WorldClock
	*/
	public Clock getClock() {
		return this.clock;
	}

	/**
	* globalԂݒ肵܂B
	* @param space ݒ肷
	*/
	public void setSpace(Space space) {
		this.space = space;
	}

	/**
	* WorldێԂ擾܂B
	* @return space 
	*/
	public Space getSpace() {
		return this.space;
	}

	/*********************************
	*  RandomNumberGenerator
	*********************************/

	/**
	* nameRandomNumberGeneratorĕԂ܂B
	* @param randomNumberGeneratorName RandomNumberGeneratorname
	* @return RandomNumberGeneratoriȂnullj
	*/
	public RandomNumberGenerator getRandomNumberGenerator(String name) {
		return this.randomManager.getRandomNumberGenerator(name);
	}

	/**
	* DefaultRandomNumberGeneratorĕԂ܂B
	* @param randomNumberGeneratorName RandomNumberGeneratorname
	* @return RandomNumberGeneratoriȂnullj
	*/
	public RandomNumberGenerator getRandomNumberGenerator() {
		return this.randomManager.getRandomNumberGenerator(
			FMFWConstants.RANDOM_DEFAULT);
	}

	/**
	* RandomNumberGeneratorrandomMapɒǉ܂B
	* AnameRandomNumberGeneratorɂ΁Aւ܂B
	* @param newRandomNumberGenerator addRandomNumberGenerator
	*/
	public void installRandomNumberGenerator(RandomNumberGenerator random) {
		this.randomManager.installRandomNumberGenerator(random);
	}

	/**********************************
	 * _V[h֘A
	 **********************************/

	/**
	 * Returns the defaultRandomSeed.
	 * @return long
	 */
	public long getDefaultRandomSeed() {
		return defaultRandomSeed;
	}

	/**
	 * Sets the defaultRandomSeed.
	 * @param defaultRandomSeed The defaultRandomSeed to set
	 */
	public void setDefaultRandomSeed(long defaultRandomSeed) {
		this.defaultRandomSeed = defaultRandomSeed;
	}

	/**
	 * Returns the timeEventRandomSeed.
	 * @return long
	 */
	public long getTimeEventRandomSeed() {
		return timeEventRandomSeed;
	}

	/**
	 * Sets the timeEventRandomSeed.
	 * @param timeEventRandomSeed The timeEventRandomSeed to set
	 */
	public void setTimeEventRandomSeed(long timeEventRandomSeed) {
		this.timeEventRandomSeed = timeEventRandomSeed;
	}

	/*********************************
	*  VocabularyǗ
	*********************************/

	/**
	* L[ɊYAgentType擾܂B
	* ݂Ȃ΁AnullԂ܂B
	* @param key L[
	*/
	public AgentType getAgentType(String key) {
		return this.modelContainer.getAgentType(key);
	}

	/**
	* L[ɊYBehaviorType擾܂B
	* ݂Ȃ΁AnullԂ܂B
	* @param key L[
	*/
	public BehaviorType getBehaviorType(String key) {
		return this.modelContainer.getBehaviorType(key);
	}

	/**
	* BehaviorɊYBehaviorType擾܂B
	* ݂Ȃ΁AnullԂ܂B
	* @param key L[
	*/
	public BehaviorType getBehaviorType(Behavior behavior) {
		return this.modelContainer.getBehaviorType(
			behavior.getClass().getName());
	}

	/**
	* L[ɊYGoodsType擾܂B
	* ݂Ȃ΁AnullԂ܂B
	* @param key L[
	*/
	public GoodsType getGoodsType(String key) {
		return this.modelContainer.getGoodsType(key);
	}

	/**
	* L[ɊYInformationType擾܂B
	* ݂Ȃ΁AnullԂ܂B
	* @param key L[
	*/
	public InformationType getInformationType(String key) {
		return this.modelContainer.getInformationType(key);
	}

	/**
	* InformationɊYInformationType擾܂B
	* ݂Ȃ΁AnullԂ܂B
	* @param key L[
	*/
	public InformationType getInformationType(Information information) {
		return this.modelContainer.getInformationType(
			information.getClass().getName());
	}

	/**
	* L[ɊYRelationType擾܂B
	* ݂Ȃ΁AnullԂ܂B
	* @param key L[
	*/
	public RelationType getRelationType(String key) {
		return this.modelContainer.getRelationType(key);
	}

	/**
	 * AgentType𐶐ĕԂ܂BType͕̐K̃\bhpčsĉB
	 * @param name Type̖O
	 * @return AgentType ꂽType
	 */
	public AgentType installAgentType(String name) {
		return this.modelContainer.installAgentType(name);
	}

	/**
	 * AgentType𐶐ĕԂ܂BType͕̐K̃\bhpčsĉB
	 * @param name Type̖O
	 * @return AgentType ꂽType
	 */
	public AgentType installAgentType(String name, int priority) {
		return this.modelContainer.installAgentType(name, priority);
	}

	/**
	* GoodsType𐶐ĕԂ܂BType͕̐K̃\bhpčsĉB
	* @param name Type̖O
	* @return GoodsType ꂽType
	*/
	public GoodsType installGoodsType(String name) {
		return this.modelContainer.installGoodsType(name);
	}

	/**
	* BehaviorType𐶐ĕԂ܂BType͕̐K̃\bhpčsĉB
	* @param name Type̖O
	* @return BehaviorType ꂽType
	*/
	public BehaviorType installBehaviorType(String name) {
		return this.modelContainer.installBehaviorType(name);
	}

	/**
	* RelationType𐶐ĕԂ܂BType͕̐K̃\bhpčsĉB
	* @param name Type̖O
	* @return RelationType ꂽType
	*/
	public RelationType installRelationType(String name) {
		return this.modelContainer.installRelationType(name);
	}

	/**
	* InformationType𐶐ĕԂ܂BType͕̐K̃\bhpčsĉB
	* @param name Type̖O
	* @return InformationType ꂽType
	*/
	public InformationType installInformationType(String name) {
		return this.modelContainer.installInformationType(name);
	}

	/*********************************
	*  PriorityǗ
	*********************************/

	/**
	 * AgentTypeɑΉPriorityԂ܂B
	 * A݂ȂnullԂ܂B
	 * @param agentType 擾PriorityType
	 * @return Priority YPriority
	 */
	public int getPriority(AgentType agentType) {
		return this.modelContainer.getPriority(agentType);
	}

	/**
	 * Priorityǉݒ肵܂BintŎw肵Priority𐶐Ēǉ܂B
	 * int̒lPriorityɂ΁Aɒǉ܂B
	 * @param priorityValue ǉPriority
	 * @param agentType ֘AtType
	 */
	public void setPriority(AgentType agentType, int priority) {
		this.modelContainer.setPriority(agentType, priority);
	}

	/******************
	 * CxgM֘A
	 ******************/

	protected void fireAgentCreated(UpdateWorldEvent e) {
		if (getPresentationContainer() != null) {
			getPresentationContainer().getUpdateEventManager().agentCreated(e);
		}
	}

	protected void fireAgentDestroyed(UpdateWorldEvent e) {
		if (getPresentationContainer() != null) {
			getPresentationContainer().getUpdateEventManager().agentDestroyed(
				e);
		}
	}

	protected void fireGoodsCreated(UpdateWorldEvent e) {
		if (getPresentationContainer() != null) {
			getPresentationContainer().getUpdateEventManager().goodsCreated(e);
		}
	}

	protected void fireGoodsConsumed(UpdateWorldEvent e) {
		if (getPresentationContainer() != null) {
			getPresentationContainer().getUpdateEventManager().goodsConsumed(e);
		}
	}

	//	/******************
	//	 * VACY֘A
	//	 ******************/
	//
	//	private void readObject(ObjectInputStream stream)
	//		throws IOException, ClassNotFoundException {
	//		//R[h@VACYStrategy͍čl̕Kv(V)
	//		//VACY߂ƂVocabraryǂޕKv̂łƂ肠Ă
	//		this.modelContainer = BESP.container.getModelContainer();
	//		stream.defaultReadObject();
	//	}

}
