/*
 * AbstractBehavior.java
 * 
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.besp.model.fmfw.behavior;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.fmfw.Behavior;
import org.boxed_economy.besp.model.fmfw.TimeEvent;
import org.boxed_economy.besp.model.fmfw.behaviorimpl.DefaultRootStateMachine;
import org.boxed_economy.besp.model.fmfw.update.UpdateBehaviorEvent;

/**
 * @author macchan
 * @version $Id: AbstractBehavior.java,v 1.1 2004/03/21 12:07:48 macchan Exp $
 */
public abstract class AbstractBehavior extends Behavior {

	private static final long serialVersionUID = 1L;

	private static final Logger logger =
		Logger.getLogger(AbstractBehavior.class.getName());

	//DefaultRoot̉factoryNXɂȂĂB
	//DefaultRootfactoryŐ
	private transient RootStateMachine stateMachine =
		new DefaultRootStateMachine(this);

	/**
	 * Constructor for AbstractBehavior.
	 */
	public AbstractBehavior() {
		super();
	}

	/********************
	 * StateMachine֌W
	 ********************/

	/**
	 * Returns the stateMachine.
	 * @return RootStateMachine
	 */
	public final RootStateMachine getStateMachine() {
		return this.stateMachine;
	}

	public void addState(State state) {
		this.stateMachine.addState(state);
	}

	public void setInitialState(State state) {
		this.stateMachine.setInitialState(state);
	}

	public void setHistoryState(State state) {
		this.stateMachine.setHistoryState(state);
	}

	public void addTerminalState(State state) {
		this.stateMachine.addTerminalState(state);
	}

	public List getCurrentPath() {
		return this.stateMachine.getCurrentStatePath();
	}

	public State getState() {
		List path = stateMachine.getCurrentStatePath();
		if (!path.isEmpty()) {
			Object top = path.get(path.size() - 1);
			if (top instanceof State) {
				return (State) top;
			}
		}

		return null;
	}

	/***************
	 * JnA~
	 ***************/

	/**
	 * Behavior#run̎ł
	 * ԋ@BJn邽߂̃\bhłB
	 */
	protected final void run() {
		this.initializeStateMachine();
		this.initialize();
		this.getStateMachine().initialize();
		this.terminateCheck();
	}

	/**
	 * Behavior#run̎ł
	 * ԋ@B~邽߂̃\bhłB
	 */
	protected final void stop() {
		this.getStateMachine().terminate();
		this.terminate();
	}

	protected abstract void initializeStateMachine();

	protected abstract void initialize();

	protected abstract void terminate();

	/***************
	 * Event֘A
	 ***************/

	/**
	 * Behavior#isReceivableEvent̎ł			
	 * RelationChannel̊J݂Ɋւċ߂郁\bhłB
	 * @param e J݂߂Channel̏܂Event
	 * @return boolean J݂邩̐^U
	 */
	protected final boolean isReceivableEvent(Event e) {
		return this.stateMachine.isReceivableEvent(e);
	}

	/**
	 * Behavior#receiveEvent̎ł
	 * ChannelAAgent瑗ꂽEvent󂯎郁\bhłB
	 * @param e ꂽCxg
	 */
	protected final void receiveEvent(Event e) {
		if (e instanceof TimeEvent) {
			this.firePrepareTimeEventReceive(
				new UpdateBehaviorEvent(this, getState()));
		}
		this.stateMachine.receiveEvent(e);
		this.terminateCheck();
		if (e instanceof TimeEvent) {
			this.fireTimeEventReceived(
				new UpdateBehaviorEvent(this, getState()));
		}
	}

	/**
	 * IԂǂׂāAIԂłΎgAgent폜܂
	 */
	private final void terminateCheck() {
		if (this.stateMachine.isTerminated()) {
			this.getAgent().removeBehavior(this);
		}
	}

	/*******************
	 * VACY֌W
	 *******************/

	private void readObject(ObjectInputStream stream)
		throws IOException, ClassNotFoundException {
		stream.defaultReadObject();
		this.stateMachine = new DefaultRootStateMachine(this);
		this.initializeStateMachine();
		int[] indices = (int[]) stream.readObject();
		this.stateMachine.setCurrentPathByIndices(indices);
	}

	private void writeObject(ObjectOutputStream stream) throws IOException {
		stream.defaultWriteObject();
		int[] indices = this.stateMachine.getCurrentPathIndices();
		stream.writeObject(indices);
	}

}