/*
 * BehaviorException.java
 * 
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.besp.model.fmfw.behavior;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.ModelException;

/**
 * @author macchan
 * @version $Id: BehaviorException.java,v 1.1 2004/03/21 12:07:48 macchan Exp $
 */
public class BehaviorException extends ModelException {

	private static final Logger logger =
		Logger.getLogger(BehaviorException.class.getName());

	private AbstractBehavior behavior;

	/**
	 * Constructor for BehaviorException.
	 * @param s
	 */
	public BehaviorException(AbstractBehavior behavior, String message) {
		super(message);
		this.behavior = behavior;
	}

	/**
	 * Constructor for BehaviorException.
	 * @param message
	 * @param cause
	 */
	public BehaviorException(
		AbstractBehavior behavior,
		String message,
		Throwable cause) {
		super(message, cause);
		this.behavior = behavior;
	}

	/**
	 * @see java.lang.Throwable#getMessage()
	 */
	public String getMessage() {
		StringBuffer buf = new StringBuffer();

		buf.append(super.getMessage());

		try {
			if (this.behavior != null) {
				buf.append(" in ");
				buf.append(this.behavior.getCurrentPath().toString());
			}
		}
		catch (Exception ex) {
			buf.append("??");
		}

		return buf.toString();
	}

}
