/*
 * RootStateMachine.java
 * 
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.besp.model.fmfw.behavior;

import java.util.List;

/**
 * @author macchan
 * @version $Id: RootStateMachine.java,v 1.1 2004/03/21 12:07:48 macchan Exp $
 */
public interface RootStateMachine extends StateMachine, StateMachineFactory {

	/**************************************
	 * for safety initialize and terminate
	 **************************************/

	public void initialize();

	public void terminate();

	/*************
	 * for event
	 *************/

	//	public void sendGoods(Channel channel, Goods goods);

	public boolean isReceivableEvent(Event e);

	public void receiveEvent(Event e);

	/************
	 * for trace 
	 ************/

	public List getCurrentStatePath();

	/*******************
	 * for serializing@
	 *******************/

	public int[] getCurrentPathIndices();

	public void setCurrentPathByIndices(int[] indices);

}
