/*
 * DefaultRootStateMachine.java
 * 
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.besp.model.fmfw.behaviorimpl;

import java.util.List;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior;
import org.boxed_economy.besp.model.fmfw.behavior.BehaviorException;
import org.boxed_economy.besp.model.fmfw.behavior.CompositeState;
import org.boxed_economy.besp.model.fmfw.behavior.Event;
import org.boxed_economy.besp.model.fmfw.behavior.RootStateMachine;
import org.boxed_economy.besp.model.fmfw.behavior.State;
import org.boxed_economy.besp.model.fmfw.behavior.Transition;

/**
 * @author macchan
 * @version $Id: DefaultRootStateMachine.java,v 1.1 2004/03/21 12:07:47 macchan Exp $
 */
public class DefaultRootStateMachine
	extends DefaultStateElement
	implements RootStateMachine, DefaultStateMachine {

	private static final Logger logger =
		Logger.getLogger(DefaultRootStateMachine.class.getName());

	private DefaultStateMachineImpl stateMachine = new DefaultStateMachineImpl();
	private EventManager eventManager = new EventManager(this);
	private DefaultStateMachineFactory factory;

	/**
	 * Constructor for DefaultRootStateMachine.
	 * @param behavior
	 */
	public DefaultRootStateMachine(AbstractBehavior behavior) {
		super.setBehavior(behavior);
		this.stateMachine.setBehavior(this.getBehavior());
		this.factory = new DefaultStateMachineFactory(this.getBehavior());
	}

	/**********
	 * getter 
	 **********/

	/**
	 * Returns the stateMachine.
	 * @return DefaultStateMachineImpl
	 */
	public DefaultStateMachineImpl getStateMachine() {
		return stateMachine;
	}

	/***************************
	 * stateMachine̎(Ϗ)
	 ***************************/

	/**
	 * 
	 */
	public void initialize() {
		try {
			this.stateMachine.initialize(null);
			this.receiveEvent(DefaultStateElement.AUTO); //JڂĂ
		}
		catch (Throwable th) {
			throw new BehaviorException(this.getBehavior(), "initializing", th);
		}
	}

	/**
	 * ŏIԂɂ
	 */
	public void terminate() {
		try {
			this.stateMachine.terminate();
		}
		catch (Throwable th) {
			throw new BehaviorException(this.getBehavior(), "terminating", th);
		}
	}

	/**
	 * Ԃǉ
	 */
	public void addState(State state) {
		try {
			this.stateMachine.addState(state);
			((DefaultState) state).setParent(this);
		}
		catch (Throwable th) {
			throw new BehaviorException(this.getBehavior(), "addState", th);
		}
	}

	/**
	 * Ԃݒ肷
	 */
	public void setInitialState(State state) {
		try {
			this.stateMachine.setInitialState(state);
			((DefaultState) state).setParent(this);
		}
		catch (Throwable th) {
			throw new BehaviorException(this.getBehavior(), "setInitialState", th);
		}
	}

	/**
	 * Ԃݒ肷
	 */
	public void setHistoryState(State state) {
		try {
			this.stateMachine.setHistoryState(state);
			((DefaultState) state).setParent(this);
		}
		catch (Throwable th) {
			throw new BehaviorException(this.getBehavior(), "setHistoryState", th);
		}
	}

	/**
	 * IԂݒ肷
	 */
	public void addTerminalState(State state) {
		try {
			this.stateMachine.addTerminalState(state);
			((DefaultState) state).setParent(this);
		}
		catch (Throwable th) {
			throw new BehaviorException(this.getBehavior(), "addTerminalState", th);
		}
	}

	/**
	 * IԂǂׂ܂
	 */
	public boolean isTerminated() {
		return this.stateMachine.isTerminated();
	}

	/**
	 * M\ǂ𒲂ׂ܂
	 */
	public boolean isReceivableEvent(Event e) {
		try {
			return this.eventManager.isReceivableEvent(e);
		}
		catch (Throwable th) {
			throw new BehaviorException(this.getBehavior(), "isReceivableEvent", th);
		}
	}

	/**
	 * CxgM܂
	 */
	public void receiveEvent(Event e) {
		try {
			this.eventManager.receiveEvent(e);
		}
		catch (Throwable th) {
			throw new BehaviorException(this.getBehavior(), "receiveEvent", th);
		}
	}

	/**
	 * ԂĐݒiJڒɌĂ΂j܂
	 */
	public void resetCurrentState(ElementStack stack) {
		try {
			this.stateMachine.resetCurrentState(stack);
		}
		catch (Throwable th) {
			throw new BehaviorException(
				this.getBehavior(),
				"replaceCurrentState",
				th);
		}
	}

	/**
	 * pX擾
	 */
	public List getCurrentStatePath() {
		try {
			List list = this.stateMachine.getCurrentPath();
			list.add(0, this);
			return list;
		}
		catch (Throwable th) {
			throw new BehaviorException(this.getBehavior(), "getCurrentPath()", th);
		}
	}

	/****************
	 * factory(Ϗ)
	 ****************/
	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.StateMachineFactory#createCompositeState(String)
	 */
	public CompositeState createCompositeState(String name) {
		return this.factory.createCompositeState(name);
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.StateMachineFactory#createState(String)
	 */
	public State createState(String name) {
		return this.factory.createCompositeState(name);
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.StateMachineFactory#createInitialState()
	 */
	public State createInitialState() {
		return this.factory.createInitialState();
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.StateMachineFactory#createTerminalState()
	 */
	public State createTerminalState() {
		return this.factory.createTerminalState();
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.StateMachineFactory#createHistoryState()
	 */
	public State createHistoryState() {
		return this.factory.createHistoryState();
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.StateMachineFactory#createTransition()
	 */
	public Transition createTransition() {
		return this.factory.createTransition();
	}

	/*******************
	 * for serializing
	 ******************/

	/**
	 * pXindex̔z擾܂
	 */
	public int[] getCurrentPathIndices() {
		IndexStack stack = new IndexStack();
		this.stateMachine.getCurrentPathIndices(stack);
		return stack.getIndices();
	}

	/**
	 * ^ꂽindex̔zɂpXݒ肵܂
	 */
	public void setCurrentPathByIndices(int[] indices) {
		IndexStack stack = new IndexStack(indices);
		this.stateMachine.setCurrentPathByIndices(stack);
	}

	/***********
	 * toString
	 ***********/
	public String toString() {
		return this.chopPackage(this.getBehavior().getType().getName());
	}

}
