/*
 * DefaultState.java
 * 
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.besp.model.fmfw.behaviorimpl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.container.BESP;
import org.boxed_economy.besp.model.fmfw.behavior.Action;
import org.boxed_economy.besp.model.fmfw.behavior.BehaviorException;
import org.boxed_economy.besp.model.fmfw.behavior.CompositeState;
import org.boxed_economy.besp.model.fmfw.behavior.Event;
import org.boxed_economy.besp.model.fmfw.behavior.State;
import org.boxed_economy.besp.model.fmfw.behavior.Transition;

/**
 * @author macchan
 * @version $Id: DefaultState.java,v 1.1 2004/03/21 12:07:47 macchan Exp $
 */
public class DefaultState
	extends DefaultStateElement
	implements CompositeState, DefaultStateMachine {

	private static final Logger logger =
		Logger.getLogger(DefaultState.class.getName());

	private String name = null;
	private List transitions = new ArrayList();
	private List entryActions = new ArrayList();
	private List doActions = new ArrayList();
	private List exitActions = new ArrayList();

	private DefaultStateMachineImpl stateMachine = null;

	/**
	 * Constructor for State.
	 */
	protected DefaultState(String name) {
		this.name = name;
	}

	/********
	 * name
	 ********/

	/**
	 * Returns the name.
	 * @return String
	 */
	public String getName() {
		return name;
	}

	/********************************************************************
	 * stateMachine֘A
	 * ̃NX́Aԋ@BĂȂΓqłȂԂƂȂ܂
	 * łԂǉ΁Aԋ@B܂
	 ********************************************************************/

	private DefaultStateMachineImpl getStateMachine() {
		if (this.stateMachine == null) {
			this.stateMachine = new DefaultStateMachineImpl();
			this.stateMachine.setBehavior(this.getBehavior());
		}
		return this.stateMachine;
	}

	private boolean hasStateMachine() {
		return this.stateMachine != null;
	}

	/****************************
	 * stateMachine̎iϏj
	 ****************************/

	/**
	 * ^ꂽԂɏ
	 */
	public void initialize(ElementStack stack) {
		this.fireEntryActions();
		this.fireDoActions();
		if (this.hasStateMachine()) {
			this.getStateMachine().initialize(stack);
		}
	}

	/**
	 * ŏIԂɂ
	 */
	public void terminate() {
		if (this.hasStateMachine()) {
			this.getStateMachine().terminate();
		}
		this.fireExitActions();
	}

	/**
	 * Ԃǉ
	 */
	public void addState(State state) {
		this.getStateMachine().addState(state);
		((DefaultState) state).setParent(this);
	}

	/**
	 * Ԃݒ肷
	 */
	public void setInitialState(State state) {
		this.getStateMachine().setInitialState(state);
		((DefaultState) state).setParent(this);
	}

	/**
	 * Ԃݒ肷
	 */
	public void setHistoryState(State state) {
		this.getStateMachine().setHistoryState(state);
		((DefaultState) state).setParent(this);
	}

	/**
	 * IԂݒ肷
	 */
	public void addTerminalState(State state) {
		this.getStateMachine().addTerminalState(state);
		((DefaultState) state).setParent(this);
	}

	/****************************
	 * IDefaultstateMachine̎
	 ****************************/

	/**
	 * Cxg󂯎ʔ΂Jڂ擾܂
	 * ꍇnullԂ܂
	 */
	public DefaultTransition getReceivableTransition(Event e) {
		DefaultTransition transition = null;

		//܂ȀԂłJڂ𒲂ׂ		
		transition = this.getReceivableTransitionInternal(e);
		if (transition != null) {
			return transition;
		}

		//_ŁAcompositeȂqNXɍsiϏj
		if (this.hasStateMachine()) {
			transition = this.getStateMachine().getReceivableTransition(e);
			if (transition != null) {
				return transition;
			}
		}

		//ł΁AnullԂ
		return null;
	}

	private DefaultTransition getReceivableTransitionInternal(Event e) {
		Iterator i = this.transitions.iterator();
		while (i.hasNext()) {
			DefaultTransition transition = (DefaultTransition) i.next();
			if (transition.isReceivableEvent(e)) {
				return transition;
			}
		}
		return null;
	}

	/**
	 * IԂǂׂ܂iϏj
	 */
	public boolean isTerminated() {
		if (this.hasStateMachine()) {
			return this.getStateMachine().isTerminated();
		}
		return true;
	}

	/**
	 * ԂĐݒiJڒɌĂ΂j܂
	 */
	public void resetCurrentState(ElementStack stack) {
		if (this.hasStateMachine()) {
			this.getStateMachine().resetCurrentState(stack);
		}
		else {
			throw new BehaviorException(
				this.getBehavior(),
				"cannot set currentState in non-composite state");
		}
	}

	/**
	 * pX擾
	 */
	public List getCurrentPath() {
		if (this.hasStateMachine()) {
			List list = this.getStateMachine().getCurrentPath();
			list.add(0, this);
			return list;
		}
		else {
			List list = new ArrayList();
			list.add(this);
			return list;
		}
	}

	/**************
	 * transitions
	 **************/

	/**
	 * Method getTransitions.
	 * @return List
	 */
	public List getTransitions() {
		return new ArrayList(this.transitions);
	}

	/**
	 * Method addTransition.
	 * @param transition
	 */
	public void addTransition(Transition transition) {
		this.transitions.add(transition);
		((DefaultTransition) transition).setParent(this);
	}

	/**************
	 * entry
	 **************/

	/**
	 * Method getEntryActions.
	 * @return List
	 */
	public List getEntryActions() {
		return new ArrayList(this.entryActions);
	}

	/**
	* Method addEntryAction.
	* @param action
	*/
	public void addEntryAction(Action action) {
		this.entryActions.add(action);
	}

	/**************
	 * do
	 **************/

	/**
	 * Method getDoActions.
	 * @return List
	 */
	public List getDoActions() {
		return new ArrayList(this.doActions);
	}

	/**
	 * Method addDoAction.
	 * @param action
	 */
	public void addDoAction(Action action) {
		this.doActions.add(action);
	}

	/**************
	 * exit
	 **************/

	/**
	 * Method getExitActions.
	 * @return List
	 */
	public List getExitActions() {
		return new ArrayList(this.exitActions);
	}

	/**
	 * Method addExitAction.
	 * @param action
	 */
	public void addExitAction(Action action) {
		this.exitActions.add(action);
	}

	/******************
	 * ANV̎s
	 *******************/

	/**
	 * entry
	 */
	private void fireEntryActions() {
		if (BESP.DEBUG) {
			traceState.info("entry to " + this.getPathAsString());
		}
		this.invokeActions(this.entryActions);
	}

	/**
	 * do
	 */
	private void fireDoActions() {
		if (BESP.DEBUG) {
			traceState.info("do in " + this.getPathAsString());
		}
		this.invokeActions(this.doActions);
	}

	/**
	 * exit
	 */
	private void fireExitActions() {
		if (BESP.DEBUG) {
			traceState.info("exit from " + this.getPathAsString());
		}
		this.invokeActions(this.exitActions);
	}

	/*******************
	 * for serializing
	 ******************/
	public void setCurrentPathByIndices(IndexStack stack) {
		if (this.hasStateMachine()) {
			this.getStateMachine().setCurrentPathByIndices(stack);
		}
	}

	public void getCurrentPathIndices(IndexStack stack) {
		if (this.hasStateMachine()) {
			this.getStateMachine().getCurrentPathIndices(stack);
		}
	}

	/***********
	 * toString
	 ***********/
	public String toString() {
		return this.getName();
	}

}
