/*
 * DefaultStateElement.java
 * 
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.besp.model.fmfw.behaviorimpl;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.container.BESP;
import org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior;
import org.boxed_economy.besp.model.fmfw.behavior.Action;
import org.boxed_economy.besp.model.fmfw.behavior.Event;
import org.boxed_economy.besp.model.fmfw.behavior.GuardCondition;

/**
 * @author macchan
 * @version $Id: DefaultStateElement.java,v 1.1 2004/03/21 12:07:47 macchan Exp $
 */
public class DefaultStateElement {

	private static final Logger logger =
		Logger.getLogger(DefaultStateElement.class.getName());

	/*************
	 * static
	 *************/

	/**
	 * fobOpLogger
	 */
	public static final String TRACE = "behavior.trace";
	public static final Logger traceState = Logger.getLogger(TRACE + ".state");
	public static final Logger traceTransition =
		Logger.getLogger(TRACE + ".transition");
	public static final Logger traceAction = Logger.getLogger(TRACE + ".action");
	public static final Logger traceEvent = Logger.getLogger(TRACE + ".event");
	public static final Logger traceBehavior =
		Logger.getLogger(TRACE + ".behavior");

	/**
	 * JڃCxg
	 */
	public static class AutoTransitionEvent implements Event {
	}
	public static Event AUTO = new AutoTransitionEvent();

	/**
	 * ftHgijK[h
	 */
	public static class DefaultGuardCondition implements GuardCondition {
		public boolean isMatched(Event ev) {
			return true;
		}
	};
	public static GuardCondition EVERY = new DefaultGuardCondition();

	/**************
	 * instance
	 **************/

	private DefaultStateElement parent = null;
	private AbstractBehavior behavior = null;

	/**********
	 * parent
	 **********/

	/**
	 * em[h擾܂
	 */
	public DefaultStateElement getParent() {
		return this.parent;
	}

	/**
	 * em[hݒ肵܂
	 */
	protected void setParent(DefaultStateElement parent) {
		this.parent = parent;
	}

	/**********
	 * hierarchy
	 **********/

	/**
	 * pX擾܂
	 */
	public DefaultStateElement[] getPath() {
		List list = this.getPathAsList();
		DefaultStateElement[] elements = new DefaultStateElement[list.size()];
		return (DefaultStateElement[]) list.toArray(elements);
	}

	/**
	 * pX擾܂
	 */
	public List getPathAsList() {
		LinkedList list = new LinkedList();
		DefaultStateElement elem = this;
		while (elem != null) {
			list.addFirst(elem);
			elem = elem.parent;
		}
		return list;
	}

	//private String cashedPath = "null";

	/**
	 * pX̕擾܂
	 * 2003/08/12 LbVpč
	 * (ǁAԂ̍\𓮓Iɕς邱ƂłȂȂĂ̂ŒӂKv)
	 */
	public String getPathAsString() {
		//		if (this.cashedPath == null) {
		//			rehashPath();
		//		}
		//		return this.cashedPath;
		return getPathAsList().toString();
	}

	//	private void rehashPath() {
	//		this.cashedPath = getPathAsList().toString();
	//	}

	/**********
	 * behavior
	 **********/

	/**
	 * Returns the behavior.
	 * @return Behavior
	 */
	public AbstractBehavior getBehavior() {
		return behavior;
	}

	/**
	 * Sets the behavior.
	 * @param behavior The behavior to set
	 */
	public void setBehavior(AbstractBehavior behavior) {
		this.behavior = behavior;
	}

	/**********
	 * utility
	 **********/

	/**
	 * pbP[W؂郆[eBeB[\bh
	 */
	public String chopPackage(String str) {
		return str.substring(str.lastIndexOf(".") + 1);
	}

	/**
	 * ANVԂɎs郆[eBeB[\bh
	 */
	public void invokeActions(List actions) {
		Iterator i = actions.iterator();
		while (i.hasNext()) {
			Action action = (Action) i.next();
			if (BESP.DEBUG) {
				DefaultStateElement.traceAction.info(
					"invoke action <" + action.toString() + "> in " + this);
			}
			action.doAction();
		}
	}

}
