/*
 * DefaultStateMachineFactory.java
 * 
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.besp.model.fmfw.behaviorimpl;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior;
import org.boxed_economy.besp.model.fmfw.behavior.CompositeState;
import org.boxed_economy.besp.model.fmfw.behavior.State;
import org.boxed_economy.besp.model.fmfw.behavior.StateMachineFactory;
import org.boxed_economy.besp.model.fmfw.behavior.Transition;

/**
 * @author macchan
 * @version $Id: DefaultStateMachineFactory.java,v 1.1 2004/03/21 12:07:47 macchan Exp $
 */
public class DefaultStateMachineFactory implements StateMachineFactory {

	private static final Logger logger =
		Logger.getLogger(DefaultStateMachineFactory.class.getName());

	private AbstractBehavior behavior = null;
	
	/**
	 * RXgN^
	 */
	public DefaultStateMachineFactory(AbstractBehavior behavior) {
		this.behavior = behavior;
	}
	
	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.StateMachineFactory#createCompositeState(String)
	 */
	public CompositeState createCompositeState(String name) {
		DefaultState state = new DefaultState(name);
		state.setBehavior(behavior);
		return state;
	}
	
	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.StateMachineFactory#createState(String)
	 */
	public State createState(String name) {
		DefaultState state = new DefaultState(name);
		state.setBehavior(behavior);
		return state;
	}	
	
	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.StateMachineFactory#createInitialState()
	 */
	public State createInitialState() {
		DefaultState state = new DefaultState("InitialState");
		state.setBehavior(behavior);
		return state;
	}	
	
	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.StateMachineFactory#createTerminalState()
	 */
	public State createTerminalState() {
		DefaultState state = new DefaultState("TerminalState");
		state.setBehavior(behavior);
		return state;
	}	

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.StateMachineFactory#createHistoryState()
	 */
	public State createHistoryState() {
		DefaultState state = new DefaultState("HistoryState");
		state.setBehavior(behavior);
		return state;
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.StateMachineFactory#createTransition()
	 */
	public Transition createTransition() {
		DefaultTransition transition =  new DefaultTransition();
		transition.setBehavior(behavior);
		return transition;
	}

}
