/*
 * DefaultStateMachineImpl.java
 * 
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.besp.model.fmfw.behaviorimpl;

import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.fmfw.behavior.BehaviorException;
import org.boxed_economy.besp.model.fmfw.behavior.Event;
import org.boxed_economy.besp.model.fmfw.behavior.State;

/**
 * @author macchan
 * @version $Id: DefaultStateMachineImpl.java,v 1.1 2004/03/21 12:07:47 macchan Exp $
 */
public class DefaultStateMachineImpl
	extends DefaultStateElement
	implements DefaultStateMachine {

	private static final Logger logger =
		Logger.getLogger(DefaultStateMachineImpl.class.getName());

	private List states = new ArrayList();
	private DefaultState initialState = null;
	private DefaultState historyState = null;
	private List terminalStates = new ArrayList();

	private DefaultState currentState = null;

	/**
	 * Constructor for DefaultStateMachineImpl.
	 */
	public DefaultStateMachineImpl() {
	}

	/*****************************
	 * IDefaultStateMachine̎
	 *****************************/

	/**
	 * ܂
	 */
	public void initialize(ElementStack stack) {
		if (stack == null || stack.isEmpty()) {
			stack = this.getInitialStateStack();
		}
		this.setCurrentState(stack);
	}

	/**
	 * ŏIԂɂ܂
	 */
	public void terminate() {
		this.currentState.terminate();
	}

	/**
	 * Ԃǉ܂
	 */
	public void addState(State state) {
		this.validAddedState(state);
		this.states.add(state);
	}

	/**
	 * Ԃݒ肵܂
	 */
	public void setInitialState(State state) {
		this.initialState = (DefaultState) state;
		this.addState(state);
	}

	/**
	 * Ԃݒ肵܂
	 */
	public void setHistoryState(State state) {
		this.historyState = (DefaultState) state;
		this.addState(state);
	}

	/**
	 * ŏIԂݒ肵܂
	 */
	public void addTerminalState(State state) {
		this.terminalStates.add(state);
		this.addState(state);
	}

	/**
	 * pX擾܂
	 */
	public List getCurrentPath() {
		if (this.currentState != null) {
			return this.currentState.getCurrentPath();
		}
		else {
			return new ArrayList();
		}
	}

	/**
	 * 󂯎CxgɓKJڂTĕԂ܂
	 */
	public DefaultTransition getReceivableTransition(Event e) {
		return this.currentState.getReceivableTransition(e);
	}

	/**
	 * ŏIԂł邩ǂׂ܂
	 */
	public boolean isTerminated() {
		return this.terminalStates.contains(this.currentState);
	}

	/**
	 * ԂĐݒiJڒɌĂ΂j܂
	 */
	public void resetCurrentState(ElementStack stack) {
		if (this.currentState != null) {
			this.currentState.terminate();
		}

		this.setCurrentState(stack);
	}

	/*******************
	 * for serializing
	 ******************/
	public void setCurrentPathByIndices(IndexStack stack) {
		int index = stack.pop();
		this.currentState = (DefaultState) this.states.get(index);
		this.currentState.setCurrentPathByIndices(stack);

		this.isValid();
	}

	public void getCurrentPathIndices(IndexStack stack) {
		this.currentState.getCurrentPathIndices(stack);
		int index = this.states.indexOf(this.currentState);
		stack.push(index);

		this.isValid();
	}

	/***********
	 * private
	 ***********/

	/**
	 * Ԃݒ肷邽߂Stack܂
	 * ꂽStackɂthis.initialStatê݂Ă܂
	 */
	private ElementStack getInitialStateStack() {
		if (this.initialState == null) {
			throw new BehaviorException(this.getBehavior(), "initialState is null");
		}
		ElementStack stack = new ElementStack();
		stack.push(this.initialState);
		return stack;
	}

	/**
	 * ݂̏ԂVݒ肵܂
	 */
	private void setCurrentState(ElementStack stack) {
		DefaultState state = (DefaultState) stack.pop();

		//ԂȂΉȂ
		if (state == this.historyState) {
			return;
		}

		this.currentState = state;
		if (this.currentState != null) {
			this.currentState.initialize(stack);
		}

		this.isValid();
	}

	/*********************
	 * validater methods
	 *********************/

	/**
	 * ǉԂK؂`FbN܂
	 */
	private boolean validAddedState(State state) {
		if (((DefaultState) state).getParent() != null) {
			throw new BehaviorException(
				this.getBehavior(),
				"validAddedState() is not valid - the state have already added");
		}
		if (this.states.contains(state)) {
			throw new BehaviorException(
				this.getBehavior(),
				"validAddedState() is not valid - the state have already added in this statemachine");
		}
		if (((DefaultState) state).getBehavior() != this.getBehavior()) {
			throw new BehaviorException(
				this.getBehavior(),
				"validAddedState() is not valid - the state is not in this behavior");
		}
		return true;
	}

	/**
	 * ̏ԋ@B`FbN܂
	 */
	private boolean isValid() {
		if (!this.states.contains(this.currentState)
			&& !this.currentState.getClass().equals(TransitioningState.class)) {
			throw new BehaviorException(
				this.getBehavior(),
				"isValid() not valid currentState is not suitable state");
		}
		return true;
	}
}