/*
 * DefaultTransition.java
 * 
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.besp.model.fmfw.behaviorimpl;

import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.container.BESP;
import org.boxed_economy.besp.model.fmfw.behavior.Action;
import org.boxed_economy.besp.model.fmfw.behavior.Event;
import org.boxed_economy.besp.model.fmfw.behavior.GuardCondition;
import org.boxed_economy.besp.model.fmfw.behavior.State;
import org.boxed_economy.besp.model.fmfw.behavior.Transition;
import org.boxed_economy.besp.model.fmfw.update.UpdateBehaviorEvent;

/**
 * @author macchan
 * @version $Id: DefaultTransition.java,v 1.1 2004/03/21 12:07:47 macchan Exp $
 */
public class DefaultTransition
	extends DefaultStateElement
	implements Transition {

	private static final Logger logger =
		Logger.getLogger(DefaultTransition.class.getName());

	private DefaultState source = null;
	private DefaultState target = null;
	private Class event = DefaultStateElement.AUTO.getClass();
	private GuardCondition guardCondition = DefaultStateElement.EVERY;
	protected List actions = new ArrayList();

	/**
	 * Constructor for DefaultTransition.
	 */
	public DefaultTransition() {
		super();
	}

	/****************************
	 * implements of Transition
	 ****************************/

	public void setSourceState(State source) {
		this.source = (DefaultState) source;
		this.source.addTransition(this);
	}

	public void setTargetState(State target) {
		this.target = (DefaultState) target;
	}

	public void setEvent(Class event) {
		this.event = event;
	}

	public void addAction(Action action) {
		this.actions.add(action);
	}

	public void setGuardCondition(GuardCondition guardCondition) {
		this.guardCondition = guardCondition;
	}

	public State getSource() {
		return source;
	}

	public State getTarget() {
		return target;
	}

	/****************************
	 * Transition@̑
	 ****************************/

	/**
	 * Cxg󂯎\ǂׂ܂
	 * i܂AJډ\ǂ𒲂ׂ܂j
	 */
	protected boolean isReceivableEvent(Event e) {
		//Cxg̎ނǂ
		if (!this.event.equals(e.getClass())) {
			return false;
		}

		//K[h𖞂ǂ
		if (!this.guardCondition.isMatched(e)) {
			return false;
		}

		//Jڂ̏ꍇ́A\[XIԂłȂΑJڂȂ
		if (e == DefaultStateElement.AUTO) {
			return this.source.isTerminated();
		}

		return true;
	}

	/**
	 * Jڂ܂
	 * iJڂ̃ASYłj
	 */
	protected void doTransition() {
		if (BESP.DEBUG) {
			traceTransition.info("transition start " + this);
		}

		//Jڂ{(TransitRoot)T		
		DefaultStateMachine transitRoot = this.getTransitRoot();

		//exit current state and into special state (transitioning state)
		ElementStack toTransitioningStateStack = new ElementStack();
		toTransitioningStateStack.push(new TransitioningState(this));
		transitRoot.resetCurrentState(toTransitioningStateStack);

		//JڊJnCxgs
		getBehavior().fireTransitionStarted(
			new UpdateBehaviorEvent(getBehavior(), getBehavior().getState()));

		//invoke actions
		this.invokeActions(this.actions);

		//entry next state
		ElementStack toTargetStateStack = this.getTargetStateStack();
		transitRoot.resetCurrentState(toTargetStateStack);

		//JڏICxgs
		getBehavior().fireStateChanged(
			new UpdateBehaviorEvent(getBehavior(), getBehavior().getState()));
	}

	/**
	 * Jڂ{T
	 * {Ƃ
	 * /a/b/c/d => /a/b/f Ȃ b̂
	 * /a/b/c/d => /a/f/g/h Ȃ â
	 */
	public DefaultStateMachine getTransitRoot() {
		DefaultStateElement[] targetPath = this.target.getPath();
		int targetIndex = this.getTargetIndex();
		return (DefaultStateMachine) targetPath[targetIndex];
	}

	/**
	 * Jڂ{AJڂ̃pX擾
	 * /a/b/c/d => /a/b/f Ȃ f̂
	 * /a/b/c/d => /a/f/g/h Ȃ f/g/ĥ
	 */
	private ElementStack getTargetStateStack() {
		DefaultStateElement[] targetPath = this.target.getPath();
		int targetIndex = this.getTargetIndex();
		ElementStack targetStateStack = new ElementStack(targetPath);
		for (int i = 0; i <= targetIndex; i++) {
			targetStateStack.pop();
		}
		return targetStateStack;
	}

	/**
	 * Jڂ{̓_T
	 */
	private int getTargetIndex() {
		DefaultStateElement[] sourcePath = this.source.getPath();
		DefaultStateElement[] targetPath = this.target.getPath();

		//Ȃق̐T
		int sourceLen = sourcePath.length;
		int targetLen = targetPath.length;
		int len = sourceLen <= targetLen ? sourceLen : targetLen;

		//Jڂׂ_́AJɌĂA
		//n߂ĒlقȂƂ-1
		//ex)  b/a => b/c Ȃlen=2 i=1ŌԂl0
		for (int i = 0; i < len; i++) {
			if (sourcePath[i] != targetPath[i]) {
				return i - 1;
			}
		}

		//(炭ȑJڂȂ̂)2OԂ
		//(2OőlB̂Ȃ1OƑJڂ悤Ȃ)
		//ex)  b/a => b/a Ȃlen=2 Ԃl0
		return len - 2;

	}

	/**
	 * \Ԃ܂
	 */
	public String toString() {
		StringBuffer buf = new StringBuffer();
		String from = this.source.getPathAsString();
		String to = this.target.getPathAsString();
		buf.append(from);
		buf.append(" => ");
		buf.append(to);
		return buf.toString();
	}

}
