/*
 * ElementStack.java
 * 
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.besp.model.fmfw.behaviorimpl;

import java.util.Arrays;
import java.util.LinkedList;

import org.apache.log4j.Logger;

/**
 * @author macchan
 * @version $Id: ElementStack.java,v 1.1 2004/03/21 12:07:47 macchan Exp $
 */
public class ElementStack {

	private static final Logger logger =
		Logger.getLogger(ElementStack.class.getName());

	private LinkedList stack;

	/**
	 * Constructor for ElementStack.
	 */
	public ElementStack() {
		this.stack = new LinkedList();
	}

	/**
	 * Constructor for ElementStack.
	 */
	public ElementStack(DefaultStateElement[] elements) {
		this.stack = new LinkedList(Arrays.asList(elements));
	}

	/**
	 * ԏɃIuWFNg}܂
	 */
	public void push(DefaultStateElement element) {
		this.stack.addFirst(element);
	}

	/**
	 * ԏ̃IuWFNgo܂
	 */
	public DefaultStateElement pop() {
		return (DefaultStateElement) this.stack.removeFirst();
	}

	/**
	 * 󂩂ǂԂ܂
	 */
	public boolean isEmpty() {
		return this.stack.isEmpty();
	}

}
