/*
 * EventManager.java
 * 
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.besp.model.fmfw.behaviorimpl;

import java.util.LinkedList;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.container.BESP;
import org.boxed_economy.besp.model.fmfw.ChannelEvent;
import org.boxed_economy.besp.model.fmfw.behavior.Event;

/**
 * CxgǗ܂
 * @author macchan
 * @version $Id: EventManager.java,v 1.1 2004/03/21 12:07:47 macchan Exp $
 */
public class EventManager {

	private static final Logger logger =
		Logger.getLogger(EventManager.class.getName());

	private LinkedList eventQueue = new LinkedList();
	private boolean isTransitioning = false;

	private DefaultRootStateMachine rootStateMachine = null;

	/**
	 * Constructor for EventManager.
	 */
	public EventManager(DefaultRootStateMachine rootStateMachine) {
		this.rootStateMachine = rootStateMachine;
	}

	//	/**
	//	 * 𑗐M܂
	//	 */
	//	public void sendGoods(Channel channel, Goods goods) {
	//		channel.sendGoods(goods, this.rootStateMachine.getBehavior());
	//	}

	/**
	 * M\ǂ𒲂ׂ܂
	 */
	public boolean isReceivableEvent(Event e) {
		return this.rootStateMachine.getStateMachine().getReceivableTransition(e)
			!= null;
	}

	/**
	 * CxgM܂
	 */
	public void receiveEvent(Event e) {
		if (BESP.DEBUG) {
			DefaultStateElement.traceEvent.info(
				"receiveEvent < "
					+ this.rootStateMachine.chopPackage(e.getClass().getName())
					+ " > in "
					+ this.rootStateMachine.getPathAsString());
		}
		//oHMȂ󂯎
		if (e instanceof ChannelEvent) {
			this.rootStateMachine.getBehavior().setReceivedGoods((ChannelEvent) e);
		}

		//JڒȂ΃L[ɂ߂
		if (this.isTransitioning) {
			this.enQueue(e);
			return;
		}

		//Jڂ
		this.isTransitioning = true;
		this.doTransition(e);
		this.isTransitioning = false;

		//L[̑|
		this.deliverEvents();

		//KvȂ玩Jڂ
		this.autoTransition();
	}

	/**
	 * Jڂ
	 */
	private void doTransition(Event e) {
		DefaultTransition transition =
			this.rootStateMachine.getStateMachine().getReceivableTransition(e);
		if (transition != null) {
			transition.doTransition();
			if (BESP.DEBUG) {
				DefaultStateElement.traceBehavior.info(
					"transition completed to " + this.rootStateMachine.getCurrentStatePath());
			}
		}
		else {
			if (BESP.DEBUG) {
				DefaultStateElement.traceBehavior.info("event could not received");
			}
		}
	}

	/**
	 * L[ɎcĂCxgzM܂
	 */
	private void deliverEvents() {
		while (!this.eventQueue.isEmpty()) {
			this.rootStateMachine.receiveEvent(this.deQueue());
		}
	}

	/**
	 * JڂłƂ܂ŎIɑJڂ܂
	 */
	private void autoTransition() {
		while (this.isReceivableEvent(DefaultStateElement.AUTO)) {
			this.rootStateMachine.receiveEvent(DefaultStateElement.AUTO);
		}
	}

	/**
	 * L[ɃCxgǉ܂
	 */
	private void enQueue(Event e) {
		if (BESP.DEBUG) {
			DefaultStateElement.traceEvent.info(
				"enQueue Event in " + this.rootStateMachine.getPathAsString());
		}
		this.eventQueue.addLast(e);
		this.rootStateMachine.getBehavior().keepReceivedGoods();
	}

	/**
	 * L[Cxgo܂
	 */
	private Event deQueue() {
		if (BESP.DEBUG) {
			DefaultStateElement.traceEvent.info(
				"deQueue Event in " + this.rootStateMachine.getPathAsString());
		}
		return (Event) this.eventQueue.removeFirst();
	}

	//	/**
	//	 * 𑗐M܂
	//	 */
	//	protected void addSendGoodsEvent(Channel channel, Goods goods) {
	//		SendGoodsEvent event = new SendGoodsEvent();
	//		event.channel = channel;
	//		event.goods = goods;
	//		this.eventQueue.addLast(event);
	//	}
	//
	//	/**
	//	 * ̑M𔭉΂܂
	//	 */
	//	protected void invokeSendGoodsEvent() {
	//		while (!this.eventQueue.isEmpty()) {
	//			SendGoodsEvent event = (SendGoodsEvent) this.eventQueue.removeFirst();
	//			this.invokeSendGoodsInternal(event);
	//		}
	//	}
	//
	//	/**
	//	 * ̑MASYł
	//	 */
	//	private void invokeSendGoodsInternal(SendGoodsEvent event) {
	//		this.rootStateMachine.traceEvent.info(
	//			"sendGoods < "
	//				+ event.goods
	//				+ " > in "
	//				+ this.rootStateMachine.getCurrentPath().toString());
	//		event.channel.sendGoods(event.goods, this.rootStateMachine.getBehavior());
	//	}
	//
	//	/**
	//	 * [channel,goods] ۑpNX
	//	 */
	//	class SendGoodsEvent {
	//		Channel channel;
	//		Goods goods;
	//	}

}
