/*
 * IndexStack.java
 * 
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.besp.model.fmfw.behaviorimpl;

import java.util.LinkedList;

import org.apache.log4j.Logger;

/**
 * @author macchan
 * @version $Id: IndexStack.java,v 1.1 2004/03/21 12:07:47 macchan Exp $
 */
public class IndexStack {

	private static final Logger logger =
		Logger.getLogger(IndexStack.class.getName());

	private LinkedList stack = new LinkedList();

	/**
	 * Constructor for IndexStack.
	 */
	protected IndexStack() {
	}

	/**
	 * Constructor for IndexStack.
	 */
	protected IndexStack(int[] indices) {
		this.setIndices(indices);
	}

	/**
	 * ԏ̃IuWFNgo܂
	 */
	public int pop() {
		Integer integer = (Integer) this.stack.removeFirst();
		return integer.intValue();
	}

	/**
	 * ԏ̃IuWFNgo܂
	 */
	public void push(int index) {
		this.stack.addFirst(new Integer(index));
	}

	/**
	 * 󂩂ǂԂ܂
	 */
	public boolean isEmpty() {
		return this.stack.isEmpty();
	}

	/*************************
	 * int[]̃C^[tFCX
	 *************************/
	public int[] getIndices() {
		int[] indices = new int[this.stack.size()];
		for (int i = 0; i < this.stack.size(); i++) {
			Integer integer = (Integer) this.stack.get(i);
			indices[i] = integer.intValue();
		}
		return indices;
	}

	public void setIndices(int[] indices) {
		for (int i = 0; i < indices.length; i++) {
			this.stack.addLast(new Integer(indices[i]));
		}
	}

}
