/*
 * TransitioningState.java
 * 
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.besp.model.fmfw.behaviorimpl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.fmfw.behavior.Action;
import org.boxed_economy.besp.model.fmfw.behavior.BehaviorException;
import org.boxed_economy.besp.model.fmfw.behavior.Event;
import org.boxed_economy.besp.model.fmfw.behavior.State;
import org.boxed_economy.besp.model.fmfw.behavior.Transition;

/**
 * @author macchan
 * @version $Id: TransitioningState.java,v 1.1 2004/03/21 12:07:47 macchan Exp $
 */
public class TransitioningState extends DefaultState {

	private static final Logger logger =
		Logger.getLogger(TransitioningState.class.getName());

	private Transition transition = null;

	/**
	 * Constructor for TransitioningState.
	 */
	public TransitioningState(Transition transition) {
		super(
			transition.getSource().getName()
				+ "=>"
				+ transition.getTarget().getName());
		this.transition = transition;
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behaviorimpl.DefaultStateMachine#replaceCurrentState(ElementStack)
	 */
	public void resetCurrentState(ElementStack stack) {
		throw new BehaviorException(
			this.getBehavior(),
			"Cannot Operate while the Transition State");
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.StateMachine#initialize()
	 */
	public void initialize(ElementStack stack) {
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.StateMachine#terminate()
	 */
	public void terminate() {
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.StateMachine#addState(State)
	 */
	public void addState(State state) {
		throw new BehaviorException(
			this.getBehavior(),
			"Cannot Operate while the Transition State");
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.StateMachine#setInitialState(State)
	 */
	public void setInitialState(State state) {
		throw new BehaviorException(
			this.getBehavior(),
			"Cannot Operate while the Transition State");
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.StateMachine#addTerminalState(State)
	 */
	public void addTerminalState(State state) {
		throw new BehaviorException(
			this.getBehavior(),
			"Cannot Operate while the Transition State");
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.StateMachine#setHistoryState(State)
	 */
	public void setHistoryState(State state) {
		throw new BehaviorException(
			this.getBehavior(),
			"Cannot Operate while the Transition State");
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.StateMachine#getCurrentPath()
	 */
	public List getCurrentPath() {
		List path = new ArrayList();
		path.add(this);
		return path;
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.State#addDoAction(MenuElement)
	 */
	public void addDoAction(Action action) {
		throw new BehaviorException(
			this.getBehavior(),
			"Cannot Operate while the Transition State");
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.State#addEntryAction(MenuElement)
	 */
	public void addEntryAction(Action action) {
		throw new BehaviorException(
			this.getBehavior(),
			"Cannot Operate while the Transition State");
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.State#addExitAction(MenuElement)
	 */
	public void addExitAction(Action action) {
		throw new BehaviorException(
			this.getBehavior(),
			"Cannot Operate while the Transition State");
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behaviorimpl.DefaultState#addTransition(Transition)
	 */
	public void addTransition(Transition transition) {
		throw new BehaviorException(
			this.getBehavior(),
			"Cannot Operate while the Transition State");
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behaviorimpl.DefaultState#getDoActions()
	 */
	public List getDoActions() {
		throw new BehaviorException(
			this.getBehavior(),
			"Cannot Operate while the Transition State");
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behaviorimpl.DefaultState#getEntryActions()
	 */
	public List getEntryActions() {
		throw new BehaviorException(
			this.getBehavior(),
			"Cannot Operate while the Transition State");
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behaviorimpl.DefaultState#getExitActions()
	 */
	public List getExitActions() {
		throw new BehaviorException(
			this.getBehavior(),
			"Cannot Operate while the Transition State");
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behaviorimpl.DefaultState#getReceivableTransition(Event)
	 */
	public DefaultTransition getReceivableTransition(Event e) {
		return null;
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behaviorimpl.DefaultState#getTransitions()
	 */
	public List getTransitions() {
		return Collections.EMPTY_LIST;
	}

	/**
	 * OԂ悤ɂ܂
	 */
	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append("in transition");
		buf.append(" ");
		buf.append(this.getName());
		return buf.toString();
	}

	/**
	 * Method getTransition.
	 * @return
	 */
	public Transition getTransition() {
		return transition;
	}

}
