/*
 * DoubleInformation.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.besp.model.fmfw.informations;

import org.boxed_economy.besp.model.fmfw.AbstractInformation;

/**
 * @author macchan
 * @version $Id: DoubleInformation.java,v 1.1 2004/03/21 12:07:49 macchan Exp $
 */
public class DoubleInformation extends AbstractInformation {

	private double value = 0d;

	/**
	 * Constructor for DoubleInformation.
	 */
	public DoubleInformation(double value) {
		this.value = value;
	}

	/**
	 * Returns the value.
	 * @return double
	 */
	public double getValue() {
		return value;
	}

	/**
	 * Sets the value.
	 * @param value The value to set
	 */
	public void setValue(double value) {
		this.value = value;
	}

	/**
	 * @see Object#equals()
	 */
	public boolean equals(Object o) {
		if (!super.equals(o)) {
			DoubleInformation other = (DoubleInformation) o;
			return this.value == other.value;
		}
		else {
			return true;
		}
	}

	/**
	 * @see Object#toString()
	 */
	public String toString() {
		return new Double(value).toString();
	}

}
