/*
 * YesNoInformation.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.besp.model.fmfw.informations;

import org.boxed_economy.besp.model.fmfw.AbstractInformation;

/**
 * @author macchan
 * @version $Id: YesNoInformation.java,v 1.1 2004/03/21 12:07:49 macchan Exp $
 */
public class YesNoInformation extends AbstractInformation {

	private boolean yes;

	/**
	 * Constructor for YesNoInformation.
	 */
	public YesNoInformation(boolean yes) {
		this.yes = yes;
	}

	/**
	 * Returns the yes.
	 * @return boolean
	 */
	public boolean isYes() {
		return yes;
	}

	/**
	 * Sets the yes.
	 * @param yes The yes to set
	 */
	public void setYes(boolean yes) {
		this.yes = yes;
	}

	/**
	 * @see Object#equals()
	 */
	public boolean equals(Object o) {
		if (!super.equals(o)) {
			YesNoInformation other = (YesNoInformation) o;
			return this.yes == other.yes;
		}
		else {
			return true;
		}
	}

	/**
	 * @see Object#toString()
	 */
	public String toString() {
		return new Boolean(yes).toString();
	}

}
