/*
 * TradeEvent.java
 * 
 * Copyright (c) 2002 Boxed-Economy Project. All rights reserved.
 */
package org.boxed_economy.besp.model.fmfw.update;

import java.util.Collection;

import org.boxed_economy.besp.model.fmfw.Channel;
import org.boxed_economy.besp.model.fmfw.Relation;

/**
 * ChannelpGoods̑MsȂꂽChannel瑗Cxgł
 * 
 * @author Tsuya
 * @version $Id: TradeEvent.java,v 1.1 2004/03/21 12:07:47 macchan Exp $
 */
public class TradeEvent extends UpdateEvent {

	private Collection goodsFromChannelStart = null;
	private Collection goodsFromChannelEnd = null;
	private Relation relation = null;

	/**
	 * RXgN^łBȉ̏񂪈ɗ^܂B
	 * @param o EventM
	 * @param goodsFromChannelStart Channel瑗ꂽGoods̏W
	 * @param goodsFromChannelEnd Channel悩瑗ꂽGoods̏W
	 * @param relation Channel𐶐Relation
	 */
	public TradeEvent(
		Channel channel,
		Collection goodsFromChannelStart,
		Collection goodsFromChannelEnd,
		Relation relation) {
		super(channel);
		this.goodsFromChannelStart = goodsFromChannelStart;
		this.goodsFromChannelEnd = goodsFromChannelEnd;
		this.relation = relation;
	}

	/**
	 * Channel悩瑗ꂽGoods̃XgԂ܂B
	 * @return Collection Channel悩瑗ꂽGoods̏W
	 */
	public Collection getGoodsFromChannelEnd() {
		return goodsFromChannelEnd;
	}

	/**
	 * Channel瑗ꂽGoods̃XgԂ܂B
	 * @return Collection Channel瑗ꂽGoods̏W
	 */
	public Collection getGoodsFromChannelStart() {
		return goodsFromChannelStart;
	}

	/**
	 * Channel𐶐RelationԂ܂B
	 * @return Relation Channel𐶐Relation
	 */
	public Relation getRelation() {
		return relation;
	}

}
