/*
 * AbstractPresentationComponent.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.besp.presentation;

import org.boxed_economy.besp.model.fmfw.World;
import org.boxed_economy.besp.model.fmfw.update.TradeListener;
import org.boxed_economy.besp.model.fmfw.update.UpdateAgentListener;
import org.boxed_economy.besp.model.fmfw.update.UpdateBehaviorListener;
import org.boxed_economy.besp.model.fmfw.update.UpdateChannelListener;
import org.boxed_economy.besp.model.fmfw.update.UpdateClockListener;
import org.boxed_economy.besp.model.fmfw.update.UpdateInformationListener;
import org.boxed_economy.besp.model.fmfw.update.UpdateRelationListener;
import org.boxed_economy.besp.model.fmfw.update.UpdateStepListener;
import org.boxed_economy.besp.model.fmfw.update.UpdateWorldListener;

/**
 * PresentationComponentAbstractNX
 * @author macchan
 * @version $Id: AbstractPresentationComponent.java,v 1.3 2004/03/21 21:57:48 macchan Exp $
 */
public abstract class AbstractPresentationComponent
	implements PresentationComponent {

	private transient PresentationContainer container = null;

	/**
	 * Constructor for AbstractPresentationComponent.
	 */
	public AbstractPresentationComponent() {
		super();
	}

	/****************************
	 * PresentationComponent̎
	 ****************************/

	/**
	 * WorldԂ܂B
	 */
	public World getWorld() {
		if (container == null) {
			return null;
		}
		return this.container.getModelContainer().getModel();
	}

	/**
	 * ݒ肳ĂPresentationContainerԂ܂B
	 */
	public PresentationContainer getPresentationContainer() {
		return this.container;
	}

	/**
	 * PresentationContainerݒ肵܂B
	 */
	public void setPresentationContainer(PresentationContainer container) {
		this.container = container;
	}

	/****************************
	 * UpdateEventDeliverer
	 ****************************/

	/**
	 * @see org.boxed_economy.besp.presentation.UpdateEventDeliverer#addUpdateAgentListener(UpdateAgentListener)
	 */
	public void addUpdateAgentListener(UpdateAgentListener listener) {
		this
			.getPresentationContainer()
			.getUpdateEventManager()
			.addUpdateAgentListener(
			listener);
	}

	/**
	 * @see org.boxed_economy.besp.presentation.UpdateEventDeliverer#addUpdateBehaviorListener(UpdateBehaviorListener)
	 */
	public void addUpdateBehaviorListener(UpdateBehaviorListener listener) {
		this
			.getPresentationContainer()
			.getUpdateEventManager()
			.addUpdateBehaviorListener(listener);
	}

	/**
	 * @see org.boxed_economy.besp.presentation.UpdateEventDeliverer#addUpdateChannelListener(UpdateChannelListener)
	 */
	public void addUpdateChannelListener(UpdateChannelListener listener) {
		this
			.getPresentationContainer()
			.getUpdateEventManager()
			.addUpdateChannelListener(listener);
	}

	/**
	 * @see org.boxed_economy.besp.presentation.UpdateEventDeliverer#addUpdateClockListener(UpdateClockListener)
	 */
	public void addUpdateClockListener(UpdateClockListener listener) {
		this
			.getPresentationContainer()
			.getUpdateEventManager()
			.addUpdateClockListener(
			listener);
	}

	/**
	 * @see org.boxed_economy.besp.presentation.UpdateEventDeliverer#addUpdateClockListener(UpdateClockListener)
	 */
	public void addUpdateStepListener(UpdateStepListener listener) {
		this
			.getPresentationContainer()
			.getUpdateEventManager()
			.addUpdateStepListener(
			listener);
	}

	/**
	 * @see org.boxed_economy.besp.presentation.UpdateEventDeliverer#addUpdateInformationListener(UpdateInformationListener)
	 */
	public void addUpdateInformationListener(UpdateInformationListener listener) {
		this
			.getPresentationContainer()
			.getUpdateEventManager()
			.addUpdateInformationListener(listener);
	}

	/**
	 * @see org.boxed_economy.besp.presentation.UpdateEventDeliverer#addUpdateRelationListener(UpdateRelationListener)
	 */
	public void addUpdateRelationListener(UpdateRelationListener listener) {
		this
			.getPresentationContainer()
			.getUpdateEventManager()
			.addUpdateRelationListener(listener);
	}

	/**
	 * @see org.boxed_economy.besp.presentation.UpdateEventDeliverer#addUpdateWorldListener(UpdateWorldListener)
	 */
	public void addUpdateWorldListener(UpdateWorldListener listener) {
		this
			.getPresentationContainer()
			.getUpdateEventManager()
			.addUpdateWorldListener(
			listener);
	}

	/**
	 * @see org.boxed_economy.besp.presentation.UpdateEventDeliverer#addTradeListener(TradeListener)
	 */
	public void addTradeListener(TradeListener listener) {
		this
			.getPresentationContainer()
			.getUpdateEventManager()
			.addTradeListener(
			listener);
	}

	/**
	 * @see org.boxed_economy.besp.presentation.UpdateEventDeliverer#removeUpdateAgentListener(UpdateAgentListener)
	 */
	public void removeUpdateAgentListener(UpdateAgentListener listener) {
		this
			.getPresentationContainer()
			.getUpdateEventManager()
			.removeUpdateAgentListener(listener);
	}

	/**
	 * @see org.boxed_economy.besp.presentation.UpdateEventDeliverer#removeUpdateBehaviorListener(UpdateBehaviorListener)
	 */
	public void removeUpdateBehaviorListener(UpdateBehaviorListener listener) {
		this
			.getPresentationContainer()
			.getUpdateEventManager()
			.removeUpdateBehaviorListener(listener);
	}

	/**
	 * @see org.boxed_economy.besp.presentation.UpdateEventDeliverer#removeUpdateChannelListener(UpdateChannelListener)
	 */
	public void removeUpdateChannelListener(UpdateChannelListener listener) {
		this
			.getPresentationContainer()
			.getUpdateEventManager()
			.removeUpdateChannelListener(listener);
	}

	/**
	 * @see org.boxed_economy.besp.presentation.UpdateEventDeliverer#removeUpdateClockListener(UpdateClockListener)
	 */
	public void removeUpdateClockListener(UpdateClockListener listener) {
		this
			.getPresentationContainer()
			.getUpdateEventManager()
			.removeUpdateClockListener(listener);
	}

	/**
	 * @see org.boxed_economy.besp.presentation.UpdateEventDeliverer#removeUpdateClockListener(UpdateClockListener)
	 */
	public void removeUpdateStepListener(UpdateStepListener listener) {
		this
			.getPresentationContainer()
			.getUpdateEventManager()
			.removeUpdateStepListener(listener);
	}

	/**
	 * @see org.boxed_economy.besp.presentation.UpdateEventDeliverer#removeUpdateInformationListener(UpdateInformationListener)
	 */
	public void removeUpdateInformationListener(UpdateInformationListener listener) {
		this
			.getPresentationContainer()
			.getUpdateEventManager()
			.removeUpdateInformationListener(listener);
	}

	/**
	 * @see org.boxed_economy.besp.presentation.UpdateEventDeliverer#removeUpdateRelationListener(UpdateRelationListener)
	 */
	public void removeUpdateRelationListener(UpdateRelationListener listener) {
		this
			.getPresentationContainer()
			.getUpdateEventManager()
			.removeUpdateRelationListener(listener);
	}

	/**
	 * @see org.boxed_economy.besp.presentation.UpdateEventDeliverer#removeUpdateWorldListener(UpdateWorldListener)
	 */
	public void removeUpdateWorldListener(UpdateWorldListener listener) {
		this
			.getPresentationContainer()
			.getUpdateEventManager()
			.removeUpdateWorldListener(listener);
	}

	/**
	 * @see org.boxed_economy.besp.presentation.UpdateEventDeliverer#removeTradeListener(TradeListener)
	 */
	public void removeTradeListener(TradeListener listener) {
		this
			.getPresentationContainer()
			.getUpdateEventManager()
			.removeTradeListener(
			listener);
	}

}
