/*
 * PresentationComponentManager.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.besp.presentation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.ModelContainer;
import org.boxed_economy.besp.model.ModelContainerEvent;
import org.boxed_economy.besp.model.ModelContainerListener;
import org.boxed_economy.besp.model.ModelThread;
import org.boxed_economy.besp.model.SimulationStateEvent;
import org.boxed_economy.besp.model.SimulationStateListener;

/**
 * @author macchan
 * @version $Id: PresentationComponentManager.java,v 1.1 2004/03/21 12:07:48 macchan Exp $
 */
public class PresentationComponentManager {

	private static final Logger logger =
		Logger.getLogger(PresentationComponentManager.class.getName());

	private PresentationContainer presentationContainer = null;
	private List presentationComponents = new ArrayList();

	/************************************************
	 * RXgN^
	 ************************************************/

	/**
	 * Constructor for PresentationComponentManager.
	 */
	public PresentationComponentManager(PresentationContainer container) {
		this.presentationContainer = container;
	}

	/************************************************
	 * vR̊Ǘ
	 ************************************************/

	/**
	 * PresentationComponentǉ܂B
	 * Ɠɏs܂
	 * @param PresentationComponent ǉPresentationComponent
	 */
	public void addPresentationComponent(PresentationComponent component) {
		//łɊ܂܂ĂȂꍇ̂
		if (!presentationComponents.contains(component)) {
			this.presentationComponents.add(component); //ǉ
			this.initializePresentationComponent(component); //	
			logger.debug("PresentationComponent Added : " + component);
		}
	}

	/**
	* PresentationComponent폜܂
	* ƓɏIs܂
	* @param PresentationComponent removePresentationComponent
	*/
	public void removePresentationComponent(PresentationComponent component) {
		//łɊ܂܂Ăꍇ̂
		if (presentationComponents.contains(component)) {
			this.terminatePresentationComponent(component);
			this.presentationComponents.remove(component);
			logger.debug("PresentationComponent Removed : " + component);
		}
	}

	/**
	* ǉĂPresentationComponent擾܂
	* @return PresentationComponentlistizj
	*/
	public List getPresentationComponents() {
		return new ArrayList(presentationComponents);
	}

	/**
	 * NXɑΉv[e[VR|[lg擾܂
	 * p̂Ή܂
	 * ꍇ́AŏɌ̂Ԃ܂
	 * Ȃꍇ́AnullԂ܂
	 */
	public PresentationComponent getPresentationComponent(Class presentationComponentClass) {
		Iterator i = presentationComponents.iterator();
		while (i.hasNext()) {
			PresentationComponent component = (PresentationComponent) i.next();
			if (component.getClass().isAssignableFrom(presentationComponentClass)) {
				return component;
			}
		}
		return null;
	}

	/******************************************************
	 * PresentationComponent̏AÎ߂̃\bh
	 ******************************************************/

	/**
	 * v[e[VR|[lg܂
	 */
	private void initializePresentationComponent(PresentationComponent component) {
		component.setPresentationContainer(this.presentationContainer);
		component.initialize();

		//Kvȏꍇ́ACxgMҎo^s
		if (component instanceof PresentationContainerListener) {
			this.addPresentationContainerListener(
				(PresentationContainerListener) component);
		}
		if (component instanceof ModelContainerListener) {
			this.addModelContainerListener((ModelContainerListener) component);
		}
		if (component instanceof SimulationStateListener) {
			this.addSimulationStateListener((SimulationStateListener) component);
		}
	}

	/**
	 * v[e[VR|[lg̏Is܂
	 */
	private void terminatePresentationComponent(PresentationComponent component) {
		//Kvȏꍇ́ACxgMҎs
		if (component instanceof PresentationContainerListener) {
			this.removePresentationContainerListener(
				(PresentationContainerListener) component);
		}
		if (component instanceof ModelContainerListener) {
			this.removeModelContainerListener((ModelContainerListener) component);
		}
		if (component instanceof SimulationStateListener) {
			this.removeSimulationStateListener((SimulationStateListener) component);
		}

		component.terminate();
	}

	/****************************
	 * Xiǉ̂߂֗̕\bh
	 ****************************/

	private ModelContainer getModelContainer() {
		return this.presentationContainer.getModelContainer();
	}

	private void addModelContainerListener(ModelContainerListener l) {
		//ԂɓKCxg𔭍s
		if (this.presentationContainer.getModelContainer().getModel() != null) {
			l.prepareWorldOpen(this.createModelContainerEvent());
			l.worldOpened(this.createModelContainerEvent());
		}
		else {
			l.prepareWorldClose(this.createModelContainerEvent());
			l.worldClosed(this.createModelContainerEvent());
		}
		this.presentationContainer.getModelContainer().addModelContainerListener(l);
	}

	private void removeModelContainerListener(ModelContainerListener l) {
		this.presentationContainer.getModelContainer().addModelContainerListener(l);
	}

	private void addPresentationContainerListener(PresentationContainerListener l) {
		this.presentationContainer.addPresentationContainerListener(l);
	}

	private void removePresentationContainerListener(PresentationContainerListener l) {
		this.presentationContainer.addPresentationContainerListener(l);
	}

	private void addSimulationStateListener(SimulationStateListener l) {
		if (this.getModelContainer().getModel() != null) {
			//AE݂΁AԂɓKCxg𔭍s
			switch (this.getModelContainer().getModelThread().getState()) {
				case ModelThread.RUNNING :
					l.simulationStarted(this.createSimulationStateEvent());
					break;
				case ModelThread.STOPPING :
					l.simulationStopping(this.createSimulationStateEvent());
					break;
				case ModelThread.STOPPED :
					l.simulationStopped(this.createSimulationStateEvent());
					break;
				default :
					break;
			}
		}
		this.getModelContainer().getModelThread().addSimulationStateListener(l);
	}

	private void removeSimulationStateListener(SimulationStateListener l) {
		this.getModelContainer().getModelThread().addSimulationStateListener(l);
	}

	private ModelContainerEvent createModelContainerEvent() {
		return new ModelContainerEvent(
			this.getModelContainer(),
			this.getModelContainer().getModel());
	}

	private SimulationStateEvent createSimulationStateEvent() {
		return new SimulationStateEvent(this.getModelContainer().getModelThread());
	}

}
