/*
 * PresentationContainer.java
 *
 * Copyright (c) 2002 Boxed-Economy Project. All right reserved. 
 */
package org.boxed_economy.besp.presentation;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import javax.swing.UIManager;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.container.ArgumentManager;
import org.boxed_economy.besp.container.BESPContainer;
import org.boxed_economy.besp.model.ModelContainer;
import org.boxed_economy.besp.presentation.guifw.ErrorDialog;
import org.boxed_economy.besp.presentation.guifw.GUIContainer;
import org.boxed_economy.besp.presentation.guifw.MainFrame;
import org.boxed_economy.besp.presentation.guifw.MenuManager;
import org.boxed_economy.besp.presentation.bface.menu.MenuElement;

/**
 * v[e[VR|[lgzuv[e[VReiłB
 * CEBhEƊev[e[VR|[lgǉE폜E擾
 * 邱Ƃł܂B
 * 
 * @author rx78g
 * @version $Id: PresentationContainer.java,v 1.1 2004/03/21 12:07:48 macchan Exp $
*/
public class PresentationContainer {

	/*********
	 * static
	 *********/

	private static final Logger logger =
		Logger.getLogger(PresentationContainer.class.getName());

	public static void initializeLookAndFeel() {
		try {
			UIManager.setLookAndFeel(ArgumentManager.lookAndFeel);
		} catch (Exception ex) {
			logger.warn("invalid look and feel");
		}
	}

	static {
		initializeLookAndFeel();
	}

	/*********
	 * local
	 *********/

	//Rei
	private BESPContainer container = null;

	//ϏNX
	private UpdateEventManager updateEventDeliverer = new UpdateEventManager();
	private PresentationComponentManager presentationComponentManager =
		new PresentationComponentManager(this);

	//GUIRei
	private GUIContainer guiContainer = null;

	/**
	 * Constructor for PresentationContainer.
	 */
	public PresentationContainer(BESPContainer container) {
		this.container = container;
	}

	/*********************
	 * ,I֘A
	 *********************/

	/**
	 * ܂
	 */
	public void initialize() {
		this.addPresentationComponent(this.getGuiContainer());
	}

	/**
	 * I܂
	 */
	public void terminate() {
		List presentationComponents =
			presentationComponentManager.getPresentationComponents();
		Collections.reverse(presentationComponents);
		for (Iterator i = presentationComponents.iterator(); i.hasNext();) {
			PresentationComponent element = (PresentationComponent) i.next();
			presentationComponentManager.removePresentationComponent(element);
		}
	}

	/*************
	 * Rei֘A
	 *************/

	public ModelContainer getModelContainer() {
		return this.getContainer().getModelContainer();
	}

	public BESPContainer getContainer() {
		return this.container;
	}

	/***************************
	 * GUIContainer֘A
	 ***************************/
	/**
	 * Returns the guiContainer.
	 * @return GUIContainer
	 */
	public GUIContainer getGuiContainer() {
		if (this.guiContainer == null) {
			this.guiContainer = new GUIContainer();
		}
		return this.guiContainer;
	}

	/**
	 * MainFrame擾܂(֗\bh)
	 * @return MainFrame
	 */
	public MainFrame getMainFrame() {
		return this.getGuiContainer().getMainFrame();
	}

	/**
	 * MenuManager擾܂(֗\bh)
	 * @return MenuManager
	 */
	public MenuManager getMenuManager() {
		return this.getGuiContainer().getMenuManager();
	}

	/**
	 * Show(\)j[Actionǉ܂B(֗\bh)
	 * @param action
	 */
	public void addMenuElementToShowMenu(MenuElement element) {
		this.getGuiContainer().addMenuElementToShowMenu(element);
	}

	/**
	 * Show(\)j[Actionǉ܂B(֗\bh)
	 * @param action
	 */
	public void addMenuElementToToolsMenu(MenuElement element) {
		this.getGuiContainer().addMenuElementToToolsMenu(element);
	}

	/*********************
	 * CxgzM֘A
	 *********************/

	public UpdateEventManager getUpdateEventManager() {
		return this.updateEventDeliverer;
	}

	/*************
	 * vR֘A
	 *************/

	/**
	 * PresentationComponentǉ܂B
	 * @param PresentationComponent addPresentationComponent
	 */
	public void addPresentationComponent(PresentationComponent component) {
		this.presentationComponentManager.addPresentationComponent(component);

		this.firePresentationComponentAdded(
			new PresentationContainerEvent(this, component));
		logger.info("PresentationComponent Added : " + component);
	}

	/**
	* PresentationComponent폜܂B
	* @param PresentationComponent removePresentationComponent
	*/
	public void removePresentationComponent(PresentationComponent component) {
		this.presentationComponentManager.removePresentationComponent(
			component);

		this.firePresentationComponentRemoved(
			new PresentationContainerEvent(this, component));
		logger.info("PresentationComponent Removed : " + component);
	}

	/**
	 * Method getPresentationComponents.
	 * @return Collection
	 */
	public Collection getPresentationComponents() {
		return this.presentationComponentManager.getPresentationComponents();
	}

	/**
	 * NXɑΉv[e[VR|[lg擾܂
	 * p̂Ή܂
	 * ꍇ́AŏɌ̂Ԃ܂
	 * Ȃꍇ́AnullԂ܂
	 */
	public PresentationComponent getPresentationComponent(Class presentationComponentClass) {
		return this.presentationComponentManager.getPresentationComponent(
			presentationComponentClass);
	}

	/****************
	 * G[\֘A
	 ****************/

	/**
	 * G[\܂B
	 * @param message G[message
	 */
	public void showError(String message) {
		ErrorDialog.show(this.getMainFrame(), message);
	}

	/**
	 * G[\܂B
	 * @param message G[message
	 * @param e G[exception
	 */
	public void showError(String message, Throwable th) {
		th.printStackTrace();
		logger.error(message, th);
		ErrorDialog.show(this.getMainFrame(), message, th);
	}

	/****************
	 * ^Cg֘A
	 *****************/

	/**
	 * ^CgEBhE\܂B
	 */
	public void showTitle() {
		this.getGuiContainer().getSplashWindow().show();
	}

	/**
	 * ^CgEBhEB܂B
	 */
	public void hideTitle() {
		this.getGuiContainer().getSplashWindow().hide();
	}

	/**
	 * ^CgEBhẼbZ[WύX܂B
	 */
	public void setInitialStatusMessage(String s) {
		this.getGuiContainer().getSplashWindow().setMessage(s);
	}

	/*********************
	 * CxgzM֘A
	 *********************/
	private Vector presentationContainerListeners;

	public synchronized void addPresentationContainerListener(PresentationContainerListener l) {
		Vector v =
			presentationContainerListeners == null
				? new Vector(2)
				: (Vector) presentationContainerListeners.clone();
		if (!v.contains(l)) {
			v.addElement(l);
			presentationContainerListeners = v;
		}
	}

	public synchronized void removePresentationContainerListener(PresentationContainerListener l) {
		if (presentationContainerListeners != null
			&& presentationContainerListeners.contains(l)) {
			Vector v = (Vector) presentationContainerListeners.clone();
			v.removeElement(l);
			presentationContainerListeners = v;
		}
	}

	protected void firePresentationComponentAdded(PresentationContainerEvent e) {
		if (presentationContainerListeners != null) {
			Vector listeners = presentationContainerListeners;
			int count = listeners.size();
			for (int i = 0; i < count; i++) {
				(
					(PresentationContainerListener) listeners.elementAt(
						i)).presentationComponentAdded(
					e);
			}
		}
	}

	protected void firePresentationComponentRemoved(PresentationContainerEvent e) {
		if (presentationContainerListeners != null) {
			Vector listeners = presentationContainerListeners;
			int count = listeners.size();
			for (int i = 0; i < count; i++) {
				(
					(PresentationContainerListener) listeners.elementAt(
						i)).presentationComponentRemoved(
					e);
			}
		}
	}

}
