/*
 * UpdateEventManager.java
 *
 * Copyright (c) 2002 Boxed-Economy Project. All right reserved. 
 */
package org.boxed_economy.besp.presentation;

import java.util.Vector;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.fmfw.update.TradeEvent;
import org.boxed_economy.besp.model.fmfw.update.TradeListener;
import org.boxed_economy.besp.model.fmfw.update.UpdateAgentEvent;
import org.boxed_economy.besp.model.fmfw.update.UpdateAgentListener;
import org.boxed_economy.besp.model.fmfw.update.UpdateBehaviorEvent;
import org.boxed_economy.besp.model.fmfw.update.UpdateBehaviorListener;
import org.boxed_economy.besp.model.fmfw.update.UpdateChannelEvent;
import org.boxed_economy.besp.model.fmfw.update.UpdateChannelListener;
import org.boxed_economy.besp.model.fmfw.update.UpdateClockEvent;
import org.boxed_economy.besp.model.fmfw.update.UpdateClockListener;
import org.boxed_economy.besp.model.fmfw.update.UpdateInformationEvent;
import org.boxed_economy.besp.model.fmfw.update.UpdateInformationListener;
import org.boxed_economy.besp.model.fmfw.update.UpdateListener;
import org.boxed_economy.besp.model.fmfw.update.UpdateRelationEvent;
import org.boxed_economy.besp.model.fmfw.update.UpdateRelationListener;
import org.boxed_economy.besp.model.fmfw.update.UpdateStepListener;
import org.boxed_economy.besp.model.fmfw.update.UpdateWorldEvent;
import org.boxed_economy.besp.model.fmfw.update.UpdateWorldListener;

/**
 * UpdateEvent̔zMǗ܂BPresentationComponentϏčs܂B
 * 
 * @author rx78g
 * @version $Id: UpdateEventManager.java,v 1.2 2004/03/21 21:57:48 macchan Exp $
 */
public class UpdateEventManager
	implements UpdateListener, UpdateEventDeliverer {

	private static final Logger logger =
		Logger.getLogger(UpdateEventManager.class.getName());

	private boolean deliverUpdateAgentEvent = true;
	private boolean deliverUpdateBehaviorEvent = true;
	private boolean deliverUpdateChannelEvent = true;
	private boolean deliverUpdateClockEvent = true;
	private boolean deliverUpdateStepEvent = true;
	private boolean deliverUpdateGoodsEvent = true;
	private boolean deliverUpdateInformationEvent = true;
	private boolean deliverUpdateRelationEvent = true;
	private boolean deliverUpdateWorldEvent = true;
	private boolean deliverTradeEvent = true;

	private Vector updateAgentListeners;
	private Vector updateBehaviorListeners;
	private Vector updateChannelListeners;
	private Vector updateClockListeners;
	private Vector updateStepListeners;
	private Vector updateGoodsListeners;
	private Vector updateInformationListeners;
	private Vector updateRelationListeners;
	private Vector updateWorldListeners;
	private Vector tradeListeners;

	/******************
	 * addEventListeners
	 ******************/

	public synchronized void addUpdateAgentListener(UpdateAgentListener listener) {
		Vector v =
			updateAgentListeners == null
				? new Vector(2)
				: (Vector) updateAgentListeners.clone();
		if (!v.contains(listener)) {
			v.addElement(listener);
			updateAgentListeners = v;
		}
	}

	public synchronized void addUpdateBehaviorListener(UpdateBehaviorListener listener) {
		Vector v =
			updateBehaviorListeners == null
				? new Vector(2)
				: (Vector) updateBehaviorListeners.clone();
		if (!v.contains(listener)) {
			v.addElement(listener);
			updateBehaviorListeners = v;
		}
	}

	public synchronized void addUpdateChannelListener(UpdateChannelListener listener) {
		Vector v =
			updateChannelListeners == null
				? new Vector(2)
				: (Vector) updateChannelListeners.clone();
		if (!v.contains(listener)) {
			v.addElement(listener);
			updateChannelListeners = v;
		}
	}

	public synchronized void addUpdateClockListener(UpdateClockListener listener) {
		Vector v =
			updateClockListeners == null
				? new Vector(2)
				: (Vector) updateClockListeners.clone();
		if (!v.contains(listener)) {
			v.addElement(listener);
			updateClockListeners = v;
		}
	}

	public synchronized void addUpdateStepListener(UpdateStepListener listener) {
		Vector v =
			updateStepListeners == null
				? new Vector(2)
				: (Vector) updateStepListeners.clone();
		if (!v.contains(listener)) {
			v.addElement(listener);
			updateStepListeners = v;
		}
	}

	public synchronized void addUpdateInformationListener(UpdateInformationListener listener) {
		Vector v =
			updateInformationListeners == null
				? new Vector(2)
				: (Vector) updateInformationListeners.clone();
		if (!v.contains(listener)) {
			v.addElement(listener);
			updateInformationListeners = v;
		}
	}

	public synchronized void addUpdateRelationListener(UpdateRelationListener listener) {
		Vector v =
			updateRelationListeners == null
				? new Vector(2)
				: (Vector) updateRelationListeners.clone();
		if (!v.contains(listener)) {
			v.addElement(listener);
			updateRelationListeners = v;
		}
	}

	public synchronized void addUpdateWorldListener(UpdateWorldListener listener) {
		Vector v =
			updateWorldListeners == null
				? new Vector(2)
				: (Vector) updateWorldListeners.clone();
		if (!v.contains(listener)) {
			v.addElement(listener);
			updateWorldListeners = v;
		}
	}

	public synchronized void addTradeListener(TradeListener listener) {
		Vector v =
			tradeListeners == null
				? new Vector(2)
				: (Vector) tradeListeners.clone();
		if (!v.contains(listener)) {
			v.addElement(listener);
			tradeListeners = v;
		}
	}

	/*************************
	 * Remove Update Listeners
	 *************************/

	public synchronized void removeUpdateAgentListener(UpdateAgentListener listener) {
		if (updateAgentListeners != null
			&& updateAgentListeners.contains(listener)) {
			Vector v = (Vector) updateAgentListeners.clone();
			v.removeElement(listener);
			updateAgentListeners = v;
		}
	}

	public synchronized void removeUpdateBehaviorListener(UpdateBehaviorListener listener) {
		if (updateBehaviorListeners != null
			&& updateBehaviorListeners.contains(listener)) {
			Vector v = (Vector) updateBehaviorListeners.clone();
			v.removeElement(listener);
			updateBehaviorListeners = v;
		}
	}

	public synchronized void removeUpdateChannelListener(UpdateChannelListener listener) {
		if (updateChannelListeners != null
			&& updateChannelListeners.contains(listener)) {
			Vector v = (Vector) updateChannelListeners.clone();
			v.removeElement(listener);
			updateChannelListeners = v;
		}
	}

	public synchronized void removeUpdateClockListener(UpdateClockListener listener) {
		if (updateClockListeners != null
			&& updateClockListeners.contains(listener)) {
			Vector v = (Vector) updateClockListeners.clone();
			v.removeElement(listener);
			updateClockListeners = v;
		}
	}

	public synchronized void removeUpdateStepListener(UpdateStepListener listener) {
		if (updateStepListeners != null
			&& updateStepListeners.contains(listener)) {
			Vector v = (Vector) updateStepListeners.clone();
			v.removeElement(listener);
			updateStepListeners = v;
		}
	}

	public synchronized void removeUpdateInformationListener(UpdateInformationListener listener) {
		if (updateInformationListeners != null
			&& updateInformationListeners.contains(listener)) {
			Vector v = (Vector) updateInformationListeners.clone();
			v.removeElement(listener);
			updateInformationListeners = v;
		}
	}

	public synchronized void removeUpdateRelationListener(UpdateRelationListener listener) {
		if (updateRelationListeners != null
			&& updateRelationListeners.contains(listener)) {
			Vector v = (Vector) updateRelationListeners.clone();
			v.removeElement(listener);
			updateRelationListeners = v;
		}
	}

	public synchronized void removeUpdateWorldListener(UpdateWorldListener listener) {
		if (updateWorldListeners != null
			&& updateWorldListeners.contains(listener)) {
			Vector v = (Vector) updateWorldListeners.clone();
			v.removeElement(listener);
			updateWorldListeners = v;
		}
	}

	public synchronized void removeTradeListener(TradeListener listener) {
		if (tradeListeners != null && tradeListeners.contains(listener)) {
			Vector v = (Vector) tradeListeners.clone();
			v.removeElement(listener);
			tradeListeners = v;
		}
	}

	/***************
	 * Update Agent
	 ***************/

	/**
	 * @see org.boxed_economy.besp.model.fmfw.update.UpdateAgentListener#goodsAdded(UpdateAgentEvent)
	 */
	public void goodsAdded(UpdateAgentEvent e) {
		if (updateAgentListeners != null && this.deliverUpdateAgentEvent) {
			Vector listeners = updateAgentListeners;
			int count = listeners.size();
			for (int i = 0; i < count; i++) {
				((UpdateAgentListener) listeners.elementAt(i)).goodsAdded(e);
			}
		}
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.update.UpdateAgentListener#goodsRemoved(UpdateAgentEvent)
	 */
	public void goodsRemoved(UpdateAgentEvent e) {
		if (updateAgentListeners != null && this.deliverUpdateAgentEvent) {
			Vector listeners = updateAgentListeners;
			int count = listeners.size();
			for (int i = 0; i < count; i++) {
				((UpdateAgentListener) listeners.elementAt(i)).goodsRemoved(e);
			}
		}
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.update.UpdateAgentListener#informationAdded(UpdateAgentEvent)
	 */
	public void informationAdded(UpdateAgentEvent e) {
		if (updateAgentListeners != null && this.deliverUpdateAgentEvent) {
			Vector listeners = updateAgentListeners;
			int count = listeners.size();
			for (int i = 0; i < count; i++) {
				(
					(UpdateAgentListener) listeners.elementAt(
						i)).informationAdded(
					e);
			}
		}
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.update.UpdateAgentListener#informationRemoved(UpdateAgentEvent)
	 */
	public void informationRemoved(UpdateAgentEvent e) {
		if (updateAgentListeners != null && this.deliverUpdateAgentEvent) {
			Vector listeners = updateAgentListeners;
			int count = listeners.size();
			for (int i = 0; i < count; i++) {
				(
					(UpdateAgentListener) listeners.elementAt(
						i)).informationRemoved(
					e);
			}
		}
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.update.UpdateAgentListener#relationAdded(UpdateAgentEvent)
	 */
	public void relationAdded(UpdateAgentEvent e) {
		if (updateAgentListeners != null && this.deliverUpdateAgentEvent) {
			Vector listeners = updateAgentListeners;
			int count = listeners.size();
			for (int i = 0; i < count; i++) {
				((UpdateAgentListener) listeners.elementAt(i)).relationAdded(e);
			}
		}
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.update.UpdateAgentListener#relationRemoved(UpdateAgentEvent)
	 */
	public void relationRemoved(UpdateAgentEvent e) {
		if (updateAgentListeners != null && this.deliverUpdateAgentEvent) {
			Vector listeners = updateAgentListeners;
			int count = listeners.size();
			for (int i = 0; i < count; i++) {
				((UpdateAgentListener) listeners.elementAt(i)).relationRemoved(
					e);
			}
		}
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.update.UpdateAgentListener#relationAdded(UpdateAgentEvent)
	 */
	public void behaviorAdded(UpdateAgentEvent e) {
		if (updateAgentListeners != null && this.deliverUpdateAgentEvent) {
			Vector listeners = updateAgentListeners;
			int count = listeners.size();
			for (int i = 0; i < count; i++) {
				((UpdateAgentListener) listeners.elementAt(i)).behaviorAdded(e);
			}
		}
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.update.UpdateAgentListener#behaviorRemoved(UpdateAgentEvent)
	 */
	public void behaviorRemoved(UpdateAgentEvent e) {
		if (updateAgentListeners != null && this.deliverUpdateAgentEvent) {
			Vector listeners = updateAgentListeners;
			int count = listeners.size();
			for (int i = 0; i < count; i++) {
				((UpdateAgentListener) listeners.elementAt(i)).behaviorRemoved(
					e);
			}
		}
	}

	/****************
	 * Update Behavior
	 ****************/

	/**
	 * @see org.boxed_economy.besp.model.fmfw.update.UpdateBehaviorListener#behaviorUpdated(UpdateBehaviorEvent)
	 */
	public void transitionStarted(UpdateBehaviorEvent e) {
		if (updateBehaviorListeners != null
			&& this.deliverUpdateBehaviorEvent) {
			Vector listeners = updateBehaviorListeners;
			int count = listeners.size();
			for (int i = 0; i < count; i++) {
				(
					(UpdateBehaviorListener) listeners.elementAt(
						i)).transitionStarted(
					e);
			}
		}
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.update.UpdateBehaviorListener#behaviorUpdated(UpdateBehaviorEvent)
	 */
	public void stateChanged(UpdateBehaviorEvent e) {
		if (updateBehaviorListeners != null
			&& this.deliverUpdateBehaviorEvent) {
			Vector listeners = updateBehaviorListeners;
			int count = listeners.size();
			for (int i = 0; i < count; i++) {
				((UpdateBehaviorListener) listeners.elementAt(i)).stateChanged(
					e);
			}
		}
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.update.UpdateBehaviorListener#behaviorUpdated(UpdateBehaviorEvent)
	 */
	public void prepareTimeEventReceive(UpdateBehaviorEvent e) {
		if (updateBehaviorListeners != null
			&& this.deliverUpdateBehaviorEvent) {
			Vector listeners = updateBehaviorListeners;
			int count = listeners.size();
			for (int i = 0; i < count; i++) {
				(
					(UpdateBehaviorListener) listeners.elementAt(
						i)).prepareTimeEventReceive(
					e);
			}
		}
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.update.UpdateBehaviorListener#behaviorUpdated(UpdateBehaviorEvent)
	 */
	public void timeEventReceived(UpdateBehaviorEvent e) {
		if (updateBehaviorListeners != null
			&& this.deliverUpdateBehaviorEvent) {
			Vector listeners = updateBehaviorListeners;
			int count = listeners.size();
			for (int i = 0; i < count; i++) {
				(
					(UpdateBehaviorListener) listeners.elementAt(
						i)).timeEventReceived(
					e);
			}
		}
	}

	/****************
	 * Update Channel
	 ****************/

	/**
	 * @see org.boxed_economy.besp.model.fmfw.update.UpdateChannelListener#goodsReceive(UpdateChannelEvent)
	 */
	public void goodsReceive(UpdateChannelEvent e) {
		if (updateChannelListeners != null && this.deliverUpdateChannelEvent) {
			Vector listeners = updateChannelListeners;
			int count = listeners.size();
			for (int i = 0; i < count; i++) {
				((UpdateChannelListener) listeners.elementAt(i)).goodsReceive(
					e);
			}
		}

	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.update.UpdateChannelListener#goodsSend(UpdateChannelEvent)
	 */
	public void goodsSent(UpdateChannelEvent e) {
		if (updateChannelListeners != null && this.deliverUpdateChannelEvent) {
			Vector listeners = updateChannelListeners;
			int count = listeners.size();
			for (int i = 0; i < count; i++) {
				((UpdateChannelListener) listeners.elementAt(i)).goodsSent(e);
			}
		}
	}

	/****************
	 * Update Clock
	 ****************/

	/**
	 * @see org.boxed_economy.besp.model.fmfw.update.UpdateWorldListener#gainedClock(UpdateWorldEvent)
	 */
	public void clockGained(UpdateClockEvent e) {
		if (updateClockListeners != null && this.deliverUpdateClockEvent) {
			Vector listeners = updateClockListeners;
			int count = listeners.size();
			for (int i = 0; i < count; i++) {
				((UpdateClockListener) listeners.elementAt(i)).clockGained(e);
			}
		}
	}

	/****************
	 * Update Step
	 ****************/

	/**
	 * @see org.boxed_economy.besp.model.fmfw.update.UpdateWorldListener#gainedClock(UpdateWorldEvent)
	 */
	public void prepareStepStart(UpdateClockEvent e) {
		if (updateStepListeners != null && this.deliverUpdateStepEvent) {
			Vector listeners = updateStepListeners;
			int count = listeners.size();
			for (int i = 0; i < count; i++) {
				((UpdateStepListener) listeners.elementAt(i)).prepareStepStart(
					e);
			}
		}
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.update.UpdateWorldListener#gainedClock(UpdateWorldEvent)
	 */
	public void stepCompleted(UpdateClockEvent e) {
		if (updateStepListeners != null && this.deliverUpdateStepEvent) {
			Vector listeners = updateStepListeners;
			int count = listeners.size();
			for (int i = 0; i < count; i++) {
				((UpdateStepListener) listeners.elementAt(i)).stepCompleted(e);
			}
		}
	}

	/******************
	 * Update Information
	 ******************/

	/**
	 * @see org.boxed_economy.besp.model.fmfw.update.UpdateInformationListener#updatedInformation(UpdateInformationEvent)
	 */
	public void informationUpdated(UpdateInformationEvent e) {
		if (updateInformationListeners != null
			&& this.deliverUpdateInformationEvent) {
			Vector listeners = updateInformationListeners;
			int count = listeners.size();
			for (int i = 0; i < count; i++) {
				(
					(UpdateInformationListener) listeners.elementAt(
						i)).informationUpdated(
					e);
			}
		}
	}

	/******************
	 * Update Relation
	 ******************/

	/**
	 * @see org.boxed_economy.besp.model.fmfw.update.UpdateRelationListener#channelClosed(UpdateRelationEvent)
	 */
	public void channelClosed(UpdateRelationEvent e) {
		if (updateRelationListeners != null
			&& this.deliverUpdateRelationEvent) {
			Vector listeners = updateRelationListeners;
			int count = listeners.size();
			for (int i = 0; i < count; i++) {
				(
					(UpdateRelationListener) listeners.elementAt(
						i)).channelClosed(
					e);
			}
		}
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.update.UpdateRelationListener#channelOpened(UpdateRelationEvent)
	 */
	public void channelOpened(UpdateRelationEvent e) {
		if (updateRelationListeners != null
			&& this.deliverUpdateRelationEvent) {
			Vector listeners = updateRelationListeners;
			int count = listeners.size();
			for (int i = 0; i < count; i++) {
				(
					(UpdateRelationListener) listeners.elementAt(
						i)).channelOpened(
					e);
			}
		}
	}

	/******************
	 * Update World
	 ******************/

	/**
	 * @see org.boxed_economy.besp.model.fmfw.update.UpdateWorldListener#createdAgent(UpdateWorldEvent)
	 */
	public void agentCreated(UpdateWorldEvent e) {
		if (updateWorldListeners != null && this.deliverUpdateWorldEvent) {
			Vector listeners = updateWorldListeners;
			int count = listeners.size();
			for (int i = 0; i < count; i++) {
				((UpdateWorldListener) listeners.elementAt(i)).agentCreated(e);
			}
		}
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.update.UpdateWorldListener#destroyedAgent(UpdateWorldEvent)
	 */
	public void agentDestroyed(UpdateWorldEvent e) {
		if (updateWorldListeners != null && this.deliverUpdateWorldEvent) {
			Vector listeners = updateWorldListeners;
			int count = listeners.size();
			for (int i = 0; i < count; i++) {
				((UpdateWorldListener) listeners.elementAt(i)).agentDestroyed(
					e);
			}
		}
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.update.UpdateWorldListener#createdGoods(UpdateWorldEvent)
	 */
	public void goodsCreated(UpdateWorldEvent e) {
		if (updateWorldListeners != null && this.deliverUpdateWorldEvent) {
			Vector listeners = updateWorldListeners;
			int count = listeners.size();
			for (int i = 0; i < count; i++) {
				((UpdateWorldListener) listeners.elementAt(i)).goodsCreated(e);
			}
		}
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.update.UpdateWorldListener#consumedGoods(UpdateWorldEvent)
	 */
	public void goodsConsumed(UpdateWorldEvent e) {
		if (updateWorldListeners != null && this.deliverUpdateWorldEvent) {
			Vector listeners = updateWorldListeners;
			int count = listeners.size();
			for (int i = 0; i < count; i++) {
				((UpdateWorldListener) listeners.elementAt(i)).goodsConsumed(e);
			}
		}
	}

	/******************
	 * Trade
	 ******************/

	/**
	 * @see org.boxed_economy.besp.model.fmfw.update.TradeListener#tradeCompleted(TradeEvent)
	 */
	public void tradeCompleted(TradeEvent e) {
		if (tradeListeners != null && this.deliverTradeEvent) {
			Vector listeners = tradeListeners;
			int count = listeners.size();
			for (int i = 0; i < count; i++) {
				((TradeListener) listeners.elementAt(i)).tradeCompleted(e);
			}
		}
	}

}
