package org.boxed_economy.besp.presentation.bface;

import java.awt.BorderLayout;
import java.awt.Dimension;

import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreePath;

import org.boxed_economy.besp.container.classtree.BoxClass;
import org.boxed_economy.besp.container.classtree.BoxClassTreeElement;
import org.boxed_economy.besp.container.classtree.BoxPackage;

/**
* ClassTreePanel
*
* boxClassTreeIāANX𐶐ƂɎg_CAOp̃plłB
* ƓsetVisible(true)IɌĂ΂̂ŁAp҂́AIɌĂԕKv͂܂B
*
* pj
*
* String windowTitle = "ModelCreator̃C|[g";
* BoxClassTreeElement root = BESP.classLoader.classTreeRoot;
* ClassTreePanel _CAO = new ClassTreePanel(root);

* //_CAO\
* int  = JOptionPane.showConfirmDialog(
* presentationContainer.getMainComponent,//parentEChE
* _CAO,//c[\
* windowTitle,//^Cg
* JOptionPane.OK_CANCEL_OPTION,//OK,Cancel{^add
* JOptionPane.PLAIN_MESSAGE,//messagẽ^CvPLAIN
* null);//ACRȂ
*
*/
public class ClassTreePanel extends JPanel {

	private String classPath = "";

	private JScrollPane scrollPane = new JScrollPane();
	private JTree boxClassTree;
	private JTextField textFieldClassPath = new JTextField();
	private BorderLayout borderLayout = new BorderLayout();

	/**
	* ftHgRXgN^łB
	* eXgpdefaultc[\܂B
	* eXgȊOŗpȂłB
	*/
	public ClassTreePanel() {
		this(null);
	}

	/**
	* boxClassTreerootɂƂAinitalizeRXgN^łB
	*/
	public ClassTreePanel(BoxClassTreeElement rootElm) {
		setSize();
		createJTree(rootElm);

		try {
			jbInit();
		}
		catch (Exception e) {
			e.printStackTrace();
		}

		this.setVisible(true);
	}

	/**
	* JBuilderinitalize\bhłB
	*/
	private void jbInit() throws Exception {
		boxClassTree
			.addTreeSelectionListener(new javax.swing.event.TreeSelectionListener() {
			public void valueChanged(TreeSelectionEvent e) {
				boxClassTree_valueChanged(e);
			}
		});
		this.setLayout(borderLayout);
		this.add(scrollPane, BorderLayout.CENTER);
		scrollPane.getViewport().add(boxClassTree, null);
		this.add(textFieldClassPath, BorderLayout.NORTH);
	}

	/**
	* 傫̏lݒ肷private\bhłB
	*/
	private void setSize() {
		this.setPreferredSize(new Dimension(500, 500));
	}

	/**
	* ŗ^ꂽrootElmɁAJTreeIuWFNg𐶐܂B
	*/
	public void createJTree(BoxClassTreeElement rootElm) {
		if (rootElm == null) {
			//[g݂Ȃꍇ̓_~[ݒ肵܂B
			BoxPackage defaultroot = new BoxPackage("NoRoot");
			defaultroot.add(new BoxClass("NoClass"));
			rootElm = defaultroot;
		}
		boxClassTree = new JTree(rootElm);
	}

	/**
	* pX𓾂邽߂̃\bhłB
	*/
	public String getClassPath() {
		return textFieldClassPath.getText();
	}

	/**
	* boxClassTreeɕύXNƂ̏łB
	*/
	void boxClassTree_valueChanged(TreeSelectionEvent e) {
		TreePath pX = e.getPath();
		BoxClassTreeElement endElm =
			(BoxClassTreeElement) pX.getLastPathComponent();

		//BoxClassł͂Ȃ
		if (!(endElm instanceof BoxClass)) {
			return; //Ȃ
		}

		this.textFieldClassPath.setText(endElm.getAbsoluteName());
	}

}