/*
 * GUIUtility.java
 *
 * Copyright (c) 2002 Boxed-Economy Project. All right reserved. 
 */
package org.boxed_economy.besp.presentation.bface;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import java.net.URL;

import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.container.BESP;
import org.boxed_economy.besp.container.classtree.BoxClassTreeElement;
import org.boxed_economy.besp.presentation.PresentationException;
import org.boxed_economy.besp.presentation.guifw.GUIContainer;

/**
 * GUIPresentationComponent̏Ŗ𗧂static\bhWłB
 * 
 * @author rx78g
 * @version $Id: GUIUtility.java,v 1.1 2004/03/21 12:07:49 macchan Exp $
 */
public class GUIUtility {

	private static final Logger logger =
		Logger.getLogger(GUIUtility.class.getName());

	/***********************************************
	 * 摜֘A
	 ***********************************************/

	/**
	 * 摜ǂݍ݂܂B
	 * classLoader𗘗pimageID摜擾AImageIuWFNgƂĕԂ܂B
	 * @param imageID 摜IDłB
	 * @return 摜
	 */
	public static Image loadImage(String imageID, URL url) {
		if (url == null) {
			throw new PresentationException(
				"invalid path in loadImage imageID= " + imageID);
		}
		Image image = Toolkit.getDefaultToolkit().getImage(url);
		return image;
	}

	/**
	 * 摜ǂݍ݂܂B
	 * classLoader𗘗pimageID摜擾AImageIuWFNgƂĕԂ܂B
	 * @param imageID 摜IDłB
	 * @return 摜
	 */
	public static Image loadImage(String imageID) {
		URL url = ClassLoader.getSystemClassLoader().getResource(imageID);
		return loadImage(imageID, url);
	}

	/**
	 * 摜ǂݍ݂܂B
	 * classLoader𗘗pimageID摜擾AImageIuWFNgƂĕԂ܂B
	 * @param imageID 摜IDłB
	 * @return 摜
	 */
	public static Image loadImage(String imageID, Class clazz) {
		URL url = clazz.getResource(imageID);
		return loadImage(imageID, url);
	}

	/***********************************************
	 * ACR֘A
	 ***********************************************/

	/**
	 * ACRǂݍ݂܂B
	 * 摜ǂݍłImageIconƂĕԂ܂B
	 * @param ACRƂēǂݍމ摜ID
	 * @return ACR
	 */
	public static ImageIcon createIcon(String imageID) {
		Image image = loadImage(imageID);
		return new ImageIcon(image);
	}

	/**
	 * ACRǂݍ݂܂B
	 * 摜ǂݍłImageIconƂĕԂ܂B
	 * @param ACRƂēǂݍމ摜ID
	 * @return ACR
	 */
	public static ImageIcon createIcon(String imageID, Class clazz) {
		Image image = loadImage(imageID, clazz);
		return new ImageIcon(image);
	}

	/**
	 * component̃ACRBOXACRɂ܂B
	 * @param PresentationComponent setIconcomponent
	 */
	public static void setDefaultIcon(Component component) {
		try {
			if (component instanceof JInternalFrame) {
				((JInternalFrame) component).setFrameIcon(
					createIcon(GUIContainer.DEFAULT_ICON_IMAGE_PATH, GUIContainer.class));
			}
			else if (component instanceof Frame) {
				((Frame) component).setIconImage(
					loadImage(GUIContainer.DEFAULT_ICON_IMAGE_PATH, GUIContainer.class));
			}
		}
		catch (Exception ex) {
			logger.warn("error in setDefaultIcon", ex);
		}
	}

	/***********************************************
	 * EChEʒu֘A
	 ***********************************************/

	/**
	 * ŗ^ꂽEChE𐄏TCYɂA
	 * Aʂ̒ɃEChE悤ɁA܂B
	 * @parem window 摜̒sȂEChE
	 */
	public static void centerWindowWithPrefferedSize(Window window) {
		//Set Size As PrefferedSize
		Component component = window;
		component.setSize(component.getPreferredSize());

		centerWindow(window);
	}

	/**
	* ̃EChEʂ̒ɗ悤ɁA܂B
	* @param window EChE
	*/
	public static void centerWindow(Window window) {

		Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
		Dimension comp = window.getSize();

		window.setLocation(
			((screen.width - comp.width) / 2),
			((screen.height - comp.height) / 2));

	}

	/***********************************************
	 * c[֘A
	 ***********************************************/

	/**
	* classLoaderdefaultroot𗘗pāAboxClassTree_CAO\A
	* ̒NXIclassNameԂ܂B
	* LZꂽꍇAnullԂ܂B
	* @param windowTitle boxClassTree_CAÕ^Cg
	* @param settingComponent ̃_CAOzucomponent
	* @return IꂽclassName
	*/
	public static String showBoxClassTreeDialog(
		String windowTitle,
		Component settingComponent) {
		BoxClassTreeElement defaultroot = BESP.classTreeRoot;
		return showBoxClassTreeDialog(defaultroot, windowTitle, settingComponent);
	}

	/**
	* rootw肵āAboxClassTree_CAO\A
	* ̒NXIclassNameԂ܂B
	* LZꂽꍇAnullԂ܂B
	* @param root w肷root
	* @param windowTitle boxClassTree_CAÕ^Cg
	* @param settingComponent ̃_CAOzucomponent
	* @return IꂽclassName
	*/
	public static String showBoxClassTreeDialog(
		BoxClassTreeElement root,
		String windowTitle,
		Component settingComponent) {

		//pl
		ClassTreePanel treePanel = new ClassTreePanel(root);

		//_CAO\
		/* parentEChE, Rec, ^Cg, OK,Cancel{^, messagẽ^Cv, ACR*/
		int result =
			JOptionPane.showConfirmDialog(
				settingComponent,
				treePanel,
				windowTitle,
				JOptionPane.OK_CANCEL_OPTION,
				JOptionPane.PLAIN_MESSAGE,
				null);

		//OKȊO͂˂
		if (result != JOptionPane.OK_OPTION) {
			return null;
		}

		return treePanel.getClassPath();
	}

	/***********************************************
	 * t@C֘A
	 ***********************************************/

	/**
	 * Z[ut@CI܂
	 */
	public static File chooseSaveFile(Component parent) {

		//{bNXt@CI_CAO\
		int result = getFileChooser().showSaveDialog(parent);

		//LZꂽꍇ
		if (result != JFileChooser.APPROVE_OPTION) {
			return null;
		}

		File choseFile = getFileChooser().getSelectedFile();
		if (!choseFile.getName().endsWith(BESP.EXTENSION)) {
			choseFile = new File(choseFile.getAbsolutePath() + BESP.EXTENSION);
		}
		return choseFile;
	}

	/**
	 * [ht@CI܂
	 */
	public static File chooseOpenFile(Component parent) {

		//{bNXt@CI_CAO\
		int result = getFileChooser().showOpenDialog(parent);

		//LZꂽꍇ
		if (result != JFileChooser.APPROVE_OPTION) {
			return null;
		}

		return getFileChooser().getSelectedFile();
	}

	private static JFileChooser fileChooser = null;

	/**
	 * t@C`[U擾܂
	 */
	private static JFileChooser getFileChooser() {
		if (fileChooser == null) {
			fileChooser = new JFileChooser();
			fileChooser.setFileFilter(new BoxFileFilter());
			fileChooser.setCurrentDirectory(new File(BESP.boxHome));
		}
		return fileChooser;
	}

}

/**
 * .boxgqp̃t@CtB^
 */
class BoxFileFilter extends FileFilter {

	public boolean accept(java.io.File f) {
		if (f.getName().endsWith(BESP.EXTENSION)) {
			return true;
		}
		else if (f.isDirectory()) {
			return true;
		}
		else {
			return false;
		}
	}

	public String getDescription() {
		return GUIContainer.resource.getString("File_Description");
	}

}