/*
 * SplashWindow.java
 *
 * Copyright (c) 2002 Boxed-Economy Project. All right reserved. 
 */
package org.boxed_economy.besp.presentation.bface;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;

import javax.swing.JWindow;

import org.apache.log4j.Logger;

/**
 * XvbVEChEł
 * ̃NXBoxɈˑ܂
 * @author macchan
 * @version $Id: SplashWindow.java,v 1.1 2004/03/21 12:07:49 macchan Exp $
 */
public class SplashWindow extends JWindow {

	protected Logger logger = Logger.getLogger(getClass().getName());

	private TitlePanel titlePanel = null;

	/**
	 * Constructor for SplashWindow.
	 */
	public SplashWindow(TitlePanel titlePanel) {
		this(titlePanel, null);
	}

	/**
	 * Constructor for SplashWindow.
	 */
	public SplashWindow(TitlePanel titlePanel, Frame owner) {
		super(owner);
		this.titlePanel = titlePanel;
		this.getContentPane().add(this.titlePanel);
		this.centerWindow();
	}

	/**
	 * Returns the titlePanel.
	 * @return TitlePanel
	 */
	public TitlePanel getTitlePanel() {
		return this.titlePanel;
	}

	/**
	 * EChE𒆉ɐݒ肵܂
	 */
	protected void centerWindow() {
		this.setSize(this.getPreferredSize());

		Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
		Dimension size = this.getSize();

		this.setLocation(
			((screen.width - size.width) / 2),
			((screen.height - size.height) / 2));
	}

}
