/*
 * TitlePanel.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.besp.presentation.bface;

import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.URL;

import javax.swing.ImageIcon;
import javax.swing.JLabel;

import org.apache.log4j.Logger;

/**
 * ^Cg\plłB
 * XvbVEChE,About_CAOɎgp܂
 * @author macchan
 * @version $Id: TitlePanel.java,v 1.1 2004/03/21 12:07:49 macchan Exp $
 */
public class TitlePanel extends JLabel {

	protected Logger logger = Logger.getLogger(getClass().getName());

	//private JLabel label = new JLabel();
	private String imagePath = null;

	/**
	 * Constructor for TitlePanel.
	 */
	public TitlePanel(String imagePath) {
		this.imagePath = imagePath;
		this.initializeComponents();
	}

	/**
	 * ܂
	 */
	protected void initializeComponents() {
		this.setIcon(this.getImageIcon(this.imagePath));
	}

	/**
	 * ACR擾܂
	 */
	protected ImageIcon getImageIcon(String iconPath) {
		URL url = this.getClass().getResource(iconPath);
		MediaTracker tracker = new MediaTracker(this);
		Image img = Toolkit.getDefaultToolkit().getImage(url);
		tracker.addImage(img, 1);
		tracker.checkAll();
		ImageIcon icon = new ImageIcon(img);
		return icon;
	}

}
