/*
 * Action.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.besp.presentation.bface.menu;

import java.awt.event.ActionEvent;

import org.boxed_economy.besp.presentation.PresentationException;

/**
 * PresentationContainer̃j[ɓo^ActionNX
 * 
 * @author macchan
 * @version $Id: Action.java,v 1.1 2004/03/21 12:07:49 macchan Exp $
 */
public abstract class Action extends MenuElement {

	//-------------------------------------------------------------------
	// RXgN^
	//-------------------------------------------------------------------	

	/**
	 * @see java.lang.Object#Object()
	 */
	public Action() {
		this.initialize();
	}

	//-------------------------------------------------------------------
	// ANV֘A
	//-------------------------------------------------------------------	

	/**
	 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
	 */
	public final void actionPerformed(ActionEvent e) {
		if (this.getPresentationContainer() == null) {
			throw new PresentationException("actionPerformed called but presentationContainer is null");
		}

		try {
			this.doAction();
		}
		catch (Throwable th) {
			this.getPresentationContainer().showError(
				"Error in " + this.getName(),
				th);
		}
	}

	/**
	 * ANV܂
	 */
	protected abstract void initialize();

	/**
	 * actionPerformedɂČĂ΂܂B
	 * ANVLq܂B
	 */
	protected abstract void doAction() throws Exception;

}
