/*
 * Menu.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.besp.presentation.bface.menu;

import java.util.Iterator;
import java.util.List;

import javax.swing.JMenu;
import javax.swing.JSeparator;

/**
 * j[\NXł
 * SwingJMenubvĂ܂
 * 
 * @author macchan
 * @version $Id: Menu.java,v 1.1 2004/03/21 12:07:49 macchan Exp $
 */
public class Menu extends MenuElementGroup {

	private JMenu jMenu = new JMenu();

	/*********************
	 * RXgN^
	 *********************/

	/**
	 * Constructor for Menu.
	 */
	public Menu() {
	}

	/**
	 * Constructor for Menu.
	 */
	public Menu(String name) {
		this.setName(name);
	}

	/************************
	 * O֘A
	 ************************/

	/**
	 * @see org.boxed_economy.besp.presentation.guifw.menu.MenuElement#setName(String)
	 */
	public void setName(String name) {
		super.setName(name);
		this.jMenu.setText(this.getName());
	}

	/************************
	 * SwingComponent̎擾
	 ************************/

	/**
	 * Returns the jMenu.
	 * @return JMenu
	 */
	public JMenu getJMenu() {
		return jMenu;
	}

	/*************************************
	 * LԊ֘A
	 *************************************/

	/**
	 * j[gLݒ肳悤ɃI[o[Ch܂
	 * @see javax.swing.AbstractAction#setEnabled(boolean)
	 */
	public void setEnabled(boolean enabled) {
		this.getJMenu().setEnabled(enabled);
	}

	/*************************************
	 * XV֘A
	 *************************************/

	protected void refresh() {
		//USď		
		this.jMenu.removeAll();

		//ׂĂMenuElement\Ȃ
		this.refreshGroup(this);
	}

	/**
	 * GroupMenuɒǉ܂
	 * Menu΍ċAȂǉ܂
	 */
	private void refreshGroup(MenuElementGroup group) {
		List elements = group.getElements();
		Iterator i = elements.iterator();
		while (i.hasNext()) {
			MenuElement element = (MenuElement) i.next();
			if (element instanceof Action) {
				this.jMenu.add((Action) element);
			}
			else if (element instanceof Menu) {
				this.refreshMenu((Menu) element);
			}
			else if (element instanceof ActionGroup) {
				this.createSeparator();
				this.refreshGroup((ActionGroup) element);
				this.createSeparator();
			}
			else if (element instanceof MenuGroup) {
				this.refreshGroup((MenuGroup) element);
			}
		}
		this.trimSeparator();
	}

	private void refreshMenu(Menu menu) {
		this.jMenu.add(menu.getJMenu());
		menu.refresh();
	}

	private void createSeparator() {
		int itemCount = this.jMenu.getItemCount();
		if (itemCount != 0
			&& !JSeparator.class.isAssignableFrom(
				this.jMenu.getMenuComponent(itemCount - 1).getClass())) {
			this.jMenu.addSeparator();
		}
	}

	private void trimSeparator() {
		int itemCount = this.jMenu.getItemCount();
		if (itemCount != 0
			&& JSeparator.class.isAssignableFrom(
				this.jMenu.getMenuComponent(itemCount - 1).getClass())) {
			this.jMenu.remove(this.jMenu.getItemCount() - 1);
		}
	}

}
