/*
 * MenuBar.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.besp.presentation.bface.menu;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.swing.JMenuBar;

import org.boxed_economy.besp.presentation.PresentationContainer;

/**
 * j[o[\NX
 * SwingJMenuBarbvĂ܂
 * 
 * @author macchan
 * @version $Id: MenuBar.java,v 1.1 2004/03/21 12:07:49 macchan Exp $
 */
public class MenuBar extends MenuElementGroup {

	private JMenuBar jMenuBar = new JMenuBar();

	/**
	 * Constructor for MenuBar.
	 */
	public MenuBar() {
		super();
	}

	/************************
	 * v[e[VRei̐ݒ
	 ************************/

	/**
	 * gbvx͐ݒł悤ApublicŃI[o[Ch܂
	 * @see org.boxed_economy.besp.presentation.guifw.menu.MenuElement#setPresentationContainer(PresentationContainer)
	 */
	public void setPresentationContainer(PresentationContainer container) {
		super.setPresentationContainer(container);
	}

	/************************
	 * SwingComponent̎擾
	 ************************/

	/**
	 * bvĂSwing-JMenuBarԂ܂
	 * @return JMenuBar
	 */
	public JMenuBar getJMenuBar() {
		return this.jMenuBar;
	}

	/************************
	 * XV֘A
	 ************************/

	/**
	 * j[O[v蒼܂
	 * (j[TāAJMenuBarɒǉ܂)
	 */
	protected void refresh() {
		//USč폜
		this.jMenuBar.removeAll();

		//j[T
		List menus = new ArrayList();
		this.searchMenus(this, menus);

		//j[ǉ
		Iterator i = menus.iterator();
		while (i.hasNext()) {
			Menu element = (Menu) i.next();
			this.jMenuBar.add(element.getJMenu());
		}

		this.jMenuBar.revalidate();
	}

	/**
	 * O[vz̃j[ċAIɒT܂
	 */
	private void searchMenus(MenuElementGroup group, List list) {
		Iterator i = group.getElements().iterator();
		while (i.hasNext()) {
			MenuElement element = (MenuElement) i.next();
			if (element instanceof Menu) {
				list.add(element);
			}
			else if (element instanceof MenuGroup) {
				this.searchMenus((MenuGroup) element, list);
			}
		}
	}

}
