/*
 * MenuElement.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.besp.presentation.bface.menu;

import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.KeyStroke;

import org.boxed_economy.besp.container.BESPContainer;
import org.boxed_economy.besp.model.ModelContainer;
import org.boxed_economy.besp.presentation.PresentationContainer;
import org.boxed_economy.besp.presentation.bface.GUIUtility;

/**
 * PresentationContainer̃j[ɓo^vfNX
 * 
 * TuNX
 * MenuElementGroup
 * Action
 * 
 * c[\\܂
 * 
 * @author macchan
 * @version $Id: MenuElement.java,v 1.1 2004/03/21 12:07:49 macchan Exp $
 */
public abstract class MenuElement extends AbstractAction {

	public static final String ICON = "icon";

	//-------------------------------------------------------------------
	// Fields
	//-------------------------------------------------------------------

	private PresentationContainer presentationContainer = null;

	//-------------------------------------------------------------------
	// Constructors
	//-------------------------------------------------------------------

	/**
	 * @see java.lang.Object#Object()
	 */
	public MenuElement() {
		super();
	}

	/**
	 * @see javax.swing.AbstractAction#AbstractAction(String)
	 */
	public MenuElement(String name) {
		this.setName(name);
	}

	//-------------------------------------------------------------------
	// Rei֘A
	//-------------------------------------------------------------------	

	/**
	 * v[e[VReiݒ肵܂
	 * c[ɉƎݒ肳悤ɂĂ邽߁AprotectedɂȂĂ܂
	 * @param presentationContainer The presentationContainer to set
	 */
	protected void setPresentationContainer(PresentationContainer container) {
		this.presentationContainer = container;
	}

	/**
	 * v[e[VRei擾܂
	 * @return PresentationContainer
	 */
	public PresentationContainer getPresentationContainer() {
		return this.presentationContainer;
	}

	/**
	 * fRei擾܂
	 * @return ModelContainer
	 */
	public ModelContainer getModelContainer() {
		return this.presentationContainer.getModelContainer();
	}

	/**
	 * BESPContainer擾܂
	 * @return BESPContainer
	 */
	public BESPContainer getContainer() {
		return this.presentationContainer.getContainer();
	}

	//-------------------------------------------------------------------
	// vpeB[֘Ai֗\bhj
	//-------------------------------------------------------------------		

	public void setName(String name) {
		this.putValue(NAME, name);
	}

	public String getName() {
		return (String) this.getValue(NAME);
	}

	public void setIcon(String imageName) {
		Icon icon = GUIUtility.createIcon(imageName);
		this.setIcon(icon);
	}

	public void setIcon(Icon icon) {
		this.putValue(ICON, icon);
	}

	public Icon getIcon() {
		return (Icon) this.getValue(ICON);
	}

	public void setSmallIcon(String imageName) {
		Icon icon = GUIUtility.createIcon(imageName);
		this.setIcon(icon);
	}

	public void setSmallIcon(Icon icon) {
		this.putValue(SMALL_ICON, icon);
	}

	public Icon getSmallIcon() {
		return (Icon) this.getValue(SMALL_ICON);
	}

	public void setAccelerator(KeyStroke keyStroke) {
		this.putValue(ACCELERATOR_KEY, keyStroke);
	}

	public KeyStroke getAccelerator() {
		return (KeyStroke) this.getValue(ACCELERATOR_KEY);
	}

}
