/*
 * MenuElementGroup.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.besp.presentation.bface.menu;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import org.boxed_economy.besp.presentation.PresentationContainer;
import org.boxed_economy.besp.presentation.PresentationException;

/**
 * j̗vfO[v邽߂̃NX
 * j[vfO[vɒǉjɂ邱ƂɂāAj[vf̏̐䂪eՂɂȂ܂B
 * 
 * TuNX
 * MenuBar(j[o[j
 * MenuGroupij[̏Ԃ𐧌䂷邽߂̃O[vj
 * Menu(j[)
 * ActionGroup(j[ɂăZp[^ŋ؂O[v)
 * 
 * @author macchan
 * @version $Id: MenuElementGroup.java,v 1.1 2004/03/21 12:07:49 macchan Exp $
 */
public abstract class MenuElementGroup
	extends MenuElement
	implements MenuElementGroupListener {

	//-------------------------------------------------------------------
	// Fields
	//-------------------------------------------------------------------

	private List elements = new ArrayList();

	//-------------------------------------------------------------------
	// Constructors
	//-------------------------------------------------------------------	

	/**
	 * @see java.lang.Object#Object()
	 */
	public MenuElementGroup() {
		super();
	}

	/**
	 * @see javax.swing.AbstractAction#AbstractAction(String)
	 */
	public MenuElementGroup(String name) {
		super(name);
	}

	//-------------------------------------------------------------------
	// qvfǗ֘A
	//-------------------------------------------------------------------	

	/**
	 * qvfǉ܂
	 * @param element
	 */
	public void add(MenuElement element) {
		this.add(element, this.elements.size());
	}

	/**
	 * IndexwŎqvfǉ܂
	 * @param element
	 * @param index
	 */
	public void add(MenuElement element, int index) {
		element.setPresentationContainer(this.getPresentationContainer());
		this.elements.add(index, element);
		if (element instanceof MenuElementGroup) {
			((MenuElementGroup) element).addActionGroupListener(this);
		}
		this.refresh();
		this.fireStateChanged(new MenuElementGroupEvent(this));
	}

	/**
	 * IndexwŎqvf폜܂
	 * @param index
	 * @return MenuElement
	 */
	public MenuElement remove(int index) {
		MenuElement element = (MenuElement) this.elements.get(index);
		this.remove(element);
		return element;
	}

	/**
	 * qvf폜܂
	 * @param element
	 */
	public void remove(MenuElement element) {
		this.elements.remove(element);
		if (element instanceof MenuElementGroup) {
			((MenuElementGroup) element).removeActionGroupListener(this);
		}
		this.refresh();
		this.fireStateChanged(new MenuElementGroupEvent(this));
	}

	/**
	 * qvf̏W擾܂
	 * @return List
	 */
	public List getElements() {
		return new ArrayList(this.elements);
	}
	//-------------------------------------------------------------------
	// Rei֘A
	//-------------------------------------------------------------------	

	/**
	 * c[z̑SĂ̗vfɐݒ肵܂
	 * iptH[}X͗܂Ac[c[ɑƂl̂ŁÃR[h͊młj
	 * @param presentationContainer The presentationContainer to set
	 */
	protected void setPresentationContainer(PresentationContainer container) {		
		super.setPresentationContainer(container);
		Iterator i = this.elements.iterator();
		while (i.hasNext()) {
			MenuElement element = (MenuElement) i.next();
			element.setPresentationContainer(container);
		}
	}	

	//-------------------------------------------------------------------
	// XV֘A
	//-------------------------------------------------------------------		
	public void stateChanged(MenuElementGroupEvent ev) {
		this.refresh();
	}

	protected void refresh() {
	}

	//-------------------------------------------------------------------
	// ANV֘A
	//-------------------------------------------------------------------	

	/**
	 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
	 */
	public final void actionPerformed(ActionEvent e) {
		throw new PresentationException("actionPerformed is not supported");
	}

	/**
	 * qvfSĐݒ肳悤ɃI[o[Ch܂
	 * @see javax.swing.AbstractAction#setEnabled(boolean)
	 */
	public void setEnabled(boolean enabled) {
		Iterator i = this.elements.iterator();
		while (i.hasNext()) {
			MenuElement element = (MenuElement) i.next();
			element.setEnabled(enabled);
		}
	}

	//-------------------------------------------------------------------
	// CxgzM֘A
	//-------------------------------------------------------------------	
	private Vector actionGroupListeners;

	public synchronized void addActionGroupListener(MenuElementGroupListener l) {
		Vector v =
			actionGroupListeners == null
				? new Vector(2)
				: (Vector) actionGroupListeners.clone();
		if (!v.contains(l)) {
			v.addElement(l);
			actionGroupListeners = v;
		}
	}

	public synchronized void removeActionGroupListener(MenuElementGroupListener l) {
		if (actionGroupListeners != null && actionGroupListeners.contains(l)) {
			Vector v = (Vector) actionGroupListeners.clone();
			v.removeElement(l);
			actionGroupListeners = v;
		}
	}

	protected void fireStateChanged(MenuElementGroupEvent e) {
		if (actionGroupListeners != null) {
			Vector listeners = actionGroupListeners;
			int count = listeners.size();
			for (int i = 0; i < count; i++) {
				((MenuElementGroupListener) listeners.elementAt(i)).stateChanged(e);
			}
		}
	}

}
