/*
 * TypeSelectionPanel.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.besp.presentation.bface.typeselector;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

import jp.ac.keio.sfc.crew.swing.jface.list.ElementChooser;
import jp.ac.keio.sfc.crew.swing.jface.list.ListPanel;
import jp.ac.keio.sfc.crew.swing.jface.list.UpDownListPanel;


/**
 * @author macchan
 * @version $Id: TypeSelectionPanel.java,v 1.1 2004/03/21 12:07:52 macchan Exp $
 */
public class TypeSelectionPanel
	extends JPanel
	implements TypeSelection, ListDataListener {

	/*********************************
	 * Instance Variables
	 *********************************/

	private String title = "";

	private ListPanel listPanel = new ListPanel();

	private List types = null;
	private Frame owner = null;

	private List updateListeners = new ArrayList();

	/**************************************
	 * Constructors
	 **************************************/

	/**
	 * Constructor for CheckBoxTypeSelection.
	 */
	public TypeSelectionPanel(Frame owner, List types, String title) {
		this.owner = owner;
		this.types = types;
		this.title = title;
		this.initialize();
	}

	/**************************************
	 * Initializer
	 **************************************/

	private void initialize() {
		//this
		this.setLayout(new BorderLayout());
		this.setBorder(BorderFactory.createTitledBorder(title));

		//listPanel
		UpDownListPanel updownListPanel = new UpDownListPanel();
		this.listPanel = updownListPanel.getListPanel();
		this.listPanel.setList(new ArrayList(this.types));
		this.listPanel.getModel().addListDataListener(this);

		//south panel
		JPanel south = createButtonPanel();

		//add		
		this.add(updownListPanel, BorderLayout.CENTER);
		this.add(south, BorderLayout.SOUTH);
	}

	private JPanel createButtonPanel() {
		//panel
		JPanel panel = new JPanel();
		panel.setLayout(new FlowLayout(FlowLayout.RIGHT));

		//button
		JButton button = new JButton();
		button.setText("Arrange");
		button.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				arrangeSelectedTypes();
			}
		});

		//add
		panel.add(button);

		return panel;
	}

	/**************************************
	 * button handler
	 **************************************/

	/**
	 * arrange selection types
	 */
	public void arrangeSelectedTypes() {
		//prepare type list
		List allTypes = new ArrayList();
		List selectedTypes = listPanel.getList();
		allTypes.addAll(this.types);
		allTypes.removeAll(selectedTypes);
		allTypes.addAll(selectedTypes);

		//show dialog
		List selected =
			ElementChooser.open(
				owner,
				allTypes,
				selectedTypes,
				"Type Chooser",
				"Please, Arrange Hide/Show Types",
				"Hide Types",
				"Show Types");

		//change data
		if (selected != null) {
			this.listPanel.getModel().removeListDataListener(this);
			listPanel.setList(selected);
			this.listPanel.getModel().addListDataListener(this);
			fireViewModelUpdated();
		}

	}

	/**************************************
	 * implements TypeSelection
	 **************************************/

	/**
	 * return selection types;
	 */
	public List getSelectedTypes() {
		return this.listPanel.getList();
	}

	/**************************************
	 * implements ListDataListener
	 **************************************/

	public void contentsChanged(ListDataEvent e) {
		fireViewModelUpdated();
	}
	public void intervalAdded(ListDataEvent e) {
		fireViewModelUpdated();
	}
	public void intervalRemoved(ListDataEvent e) {
		fireViewModelUpdated();
	}

	/**************************************
	 * update 
	 **************************************/

	/**
	 * add update listener
	 */
	public void addUpdateViewModelListener(UpdateTypeSelectionListener listener) {
		this.updateListeners.add(listener);
	}

	/**
	 * remove update listener
	 */
	public void removeUpdateViewModelListener(UpdateTypeSelectionListener listener) {
		this.updateListeners.remove(listener);
	}

	/**
	 * fire update
	 */
	public void fireViewModelUpdated() {
		Iterator i = this.updateListeners.iterator();
		while (i.hasNext()) {
			UpdateTypeSelectionListener listener = (UpdateTypeSelectionListener) i.next();
			listener.viewModelUpdated();
		}
	}

}
