/*
 * AbstractInternalFrameComponent.java
 *
 * Copyright (c) 2002 Boxed-Economy Project. All right reserved. 
 */
package org.boxed_economy.besp.presentation.guifw;

import javax.swing.JFrame;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.fmfw.World;
import org.boxed_economy.besp.model.fmfw.update.TradeListener;
import org.boxed_economy.besp.model.fmfw.update.UpdateAgentListener;
import org.boxed_economy.besp.model.fmfw.update.UpdateBehaviorListener;
import org.boxed_economy.besp.model.fmfw.update.UpdateChannelListener;
import org.boxed_economy.besp.model.fmfw.update.UpdateClockListener;
import org.boxed_economy.besp.model.fmfw.update.UpdateInformationListener;
import org.boxed_economy.besp.model.fmfw.update.UpdateRelationListener;
import org.boxed_economy.besp.model.fmfw.update.UpdateStepListener;
import org.boxed_economy.besp.model.fmfw.update.UpdateWorldListener;
import org.boxed_economy.besp.presentation.DefaultPresentationComponent;
import org.boxed_economy.besp.presentation.PresentationContainer;
import org.boxed_economy.besp.presentation.bface.GUIUtility;

/**
 * JInternalFramepGUIComponentAbstractNX
 * 
 * @author rx78g
 * @version $Id: AbstractFrameComponent.java,v 1.2 2004/03/21 21:57:49 macchan Exp $
 */
public abstract class AbstractFrameComponent
	extends JFrame
	implements GUIComponent {

	private static final Logger logger =
		Logger.getLogger(AbstractFrameComponent.class.getName());

	/**
	 * NX
	 */
	private DefaultPresentationComponent impl =
		new DefaultPresentationComponent();

	/********************
	 * RXgN^
	 ********************/

	/**
	 * Constructor for AbstractInternalFrameComponent.
	 */
	public AbstractFrameComponent() {
		super();
		this.initializeWindow();
	}

	/**
	 * ݒ܂
	 * ftHg̎łBCɓȂ΁AI[o[Ch邩Aݒ肵Ȃ܂
	 */
	protected void initializeWindow() {
		this.initializeFrame();
		this.initializeDefaultCloseOperation();
		this.initializeIcon();
	}

	/**
	 * EChE̐ݒ܂
	 * ftHg̎łBCɓȂ΁AI[o[Ch邩Aݒ肵Ȃ܂
	 */
	protected void initializeFrame() {
		this.setTitle("");
		this.setLocation(100, 100);
		this.setSize(300, 300);
	}

	/**
	 * EChE̕܂
	 * ftHg̎łBCɓȂ΁AI[o[Ch邩Aݒ肵Ȃ܂
	 */
	protected void initializeDefaultCloseOperation() {
		this.setDefaultCloseOperation(DISPOSE_ON_CLOSE);
	}

	/**
	 * t[ACR܂(Box̃ACRɂ܂)
	 * ftHg̎łBCɓȂ΁AI[o[Ch邩Aݒ肵Ȃ܂
	 */
	protected void initializeIcon() {
		GUIUtility.setDefaultIcon(this);
	}

	/***********************************
	 * PresentationComponent̎(SĈϏ)
	 ***********************************/

	/**
	 * presentationContainerԂ܂B
	 * @return zuĂpresentationContainer
	 */
	public PresentationContainer getPresentationContainer() {
		return this.impl.getPresentationContainer();
	}

	/**
	 * presentationContainerݒ肵܂B
	 * @param newPresentationContainer Vݒ肷presentationContainer
	 */
	public void setPresentationContainer(PresentationContainer newPresentationContainer) {
		this.impl.setPresentationContainer(newPresentationContainer);
	}

	/**
	 * modelԂ܂B
	 * @return modelContainerɐݒ肳Ămodel
	 */
	public World getWorld() {
		return this.impl.getWorld();
	}

	/**
	 * @see org.boxed_economy.besp.presentation.UpdateEventDeliverer#addTradeListener(TradeListener)
	 */
	public void addTradeListener(TradeListener listener) {
		this.impl.addTradeListener(listener);
	}

	/**
	 * @see org.boxed_economy.besp.presentation.UpdateEventDeliverer#addUpdateAgentListener(UpdateAgentListener)
	 */
	public void addUpdateAgentListener(UpdateAgentListener listener) {
		this.impl.addUpdateAgentListener(listener);
	}

	/**
	 * @see org.boxed_economy.besp.presentation.UpdateEventDeliverer#addUpdateBehaviorListener(UpdateBehaviorListener)
	 */
	public void addUpdateBehaviorListener(UpdateBehaviorListener listener) {
		this.impl.addUpdateBehaviorListener(listener);
	}

	/**
	 * @see org.boxed_economy.besp.presentation.UpdateEventDeliverer#addUpdateChannelListener(UpdateChannelListener)
	 */
	public void addUpdateChannelListener(UpdateChannelListener listener) {
		this.impl.addUpdateChannelListener(listener);
	}

	/**
	 * @see org.boxed_economy.besp.presentation.UpdateEventDeliverer#addUpdateClockListener(UpdateClockListener)
	 */
	public void addUpdateClockListener(UpdateClockListener listener) {
		this.impl.addUpdateClockListener(listener);
	}

	/**
	 * @see org.boxed_economy.besp.presentation.UpdateEventDeliverer#addUpdateClockListener(UpdateClockListener)
	 */
	public void addUpdateStepListener(UpdateStepListener listener) {
		this.impl.addUpdateStepListener(listener);
	}

	/**
	 * @see org.boxed_economy.besp.presentation.UpdateEventDeliverer#addUpdateInformationListener(UpdateInformationListener)
	 */
	public void addUpdateInformationListener(UpdateInformationListener listener) {
		this.impl.addUpdateInformationListener(listener);
	}

	/**
	 * @see org.boxed_economy.besp.presentation.UpdateEventDeliverer#addUpdateRelationListener(UpdateRelationListener)
	 */
	public void addUpdateRelationListener(UpdateRelationListener listener) {
		this.impl.addUpdateRelationListener(listener);
	}

	/**
	 * @see org.boxed_economy.besp.presentation.UpdateEventDeliverer#addUpdateWorldListener(UpdateWorldListener)
	 */
	public void addUpdateWorldListener(UpdateWorldListener listener) {
		this.impl.addUpdateWorldListener(listener);
	}

	/**
	 * @see org.boxed_economy.besp.presentation.UpdateEventDeliverer#removeTradeListener(TradeListener)
	 */
	public void removeTradeListener(TradeListener listener) {
		this.impl.removeTradeListener(listener);
	}

	/**
	 * @see org.boxed_economy.besp.presentation.UpdateEventDeliverer#removeUpdateAgentListener(UpdateAgentListener)
	 */
	public void removeUpdateAgentListener(UpdateAgentListener listener) {
		this.impl.removeUpdateAgentListener(listener);
	}

	/**
	 * @see org.boxed_economy.besp.presentation.UpdateEventDeliverer#removeUpdateBehaviorListener(UpdateBehaviorListener)
	 */
	public void removeUpdateBehaviorListener(UpdateBehaviorListener listener) {
		this.impl.removeUpdateBehaviorListener(listener);
	}

	/**
	 * @see org.boxed_economy.besp.presentation.UpdateEventDeliverer#removeUpdateChannelListener(UpdateChannelListener)
	 */
	public void removeUpdateChannelListener(UpdateChannelListener listener) {
		this.impl.removeUpdateChannelListener(listener);
	}

	/**
	 * @see org.boxed_economy.besp.presentation.UpdateEventDeliverer#removeUpdateClockListener(UpdateClockListener)
	 */
	public void removeUpdateClockListener(UpdateClockListener listener) {
		this.impl.removeUpdateClockListener(listener);
	}

	/**
	 * @see org.boxed_economy.besp.presentation.UpdateEventDeliverer#removeUpdateClockListener(UpdateClockListener)
	 */
	public void removeUpdateStepListener(UpdateStepListener listener) {
		this.impl.removeUpdateStepListener(listener);
	}

	/**
	 * @see org.boxed_economy.besp.presentation.UpdateEventDeliverer#removeUpdateInformationListener(UpdateInformationListener)
	 */
	public void removeUpdateInformationListener(UpdateInformationListener listener) {
		this.impl.removeUpdateInformationListener(listener);
	}

	/**
	 * @see org.boxed_economy.besp.presentation.UpdateEventDeliverer#removeUpdateRelationListener(UpdateRelationListener)
	 */
	public void removeUpdateRelationListener(UpdateRelationListener listener) {
		this.impl.removeUpdateRelationListener(listener);
	}

	/**
	 * @see org.boxed_economy.besp.presentation.UpdateEventDeliverer#removeUpdateWorldListener(UpdateWorldListener)
	 */
	public void removeUpdateWorldListener(UpdateWorldListener listener) {
		this.impl.removeUpdateWorldListener(listener);
	}

	/*********************
	 * GUIComponent̎
	 *********************/

	/**
	 * @see org.boxed_economy.besp.presentation.fw.GUIComponent#OPEN()
	 */
	public void open() {
		this.show();
	}

	/**
	 * @see org.boxed_economy.besp.presentation.fw.GUIComponent#close()
	 */
	public void close() {
		switch (this.getDefaultCloseOperation()) {
			case DISPOSE_ON_CLOSE :
				this.dispose();
				break;
			case HIDE_ON_CLOSE :
				this.hide();
				break;
			case DO_NOTHING_ON_CLOSE :
			default :
				break;
		}
	}

	/**************
	 * I[o[Ch
	 **************/

	/**
	 * EChEłɃv[e[VRei폜܂
	 */
	public void dispose() {
		this.getPresentationContainer().removePresentationComponent(this);
		super.dispose();
	}

}
