/*
 * BoxTitlePanel.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.besp.presentation.guifw;

import java.awt.Graphics;

import org.boxed_economy.besp.container.BESP;
import org.boxed_economy.besp.presentation.bface.TitlePanel;

/**
 * Boxp̃^CgplłB
 * @author macchan
 * @version $Id: BoxTitlePanel.java,v 1.1 2004/03/21 12:07:47 macchan Exp $
 */
public class BoxTitlePanel extends TitlePanel {

	private String version = BESP.VERSION;
	private String message = "";

	/**
	 * Constructor for BoxTitlePanel.
	 * @param imagePath
	 */
	public BoxTitlePanel() {
		super(GUIContainer.TITLE_IMAGE_PATH);
	}

	/**
	 * Sets the message.
	 * @param message The message to set
	 */
	public void setMessage(String message) {
		this.message = message;
		this.repaint();
	}

	/**
	 * @see javax.swing.JComponent#paintComponent(Graphics)
	 */
	protected void paintComponent(Graphics g) {
		super.paintComponent(g);
		g.drawString(this.version, 360, 220);
		g.drawString(this.message, 290, this.getHeight() - 25);
	}

}
