/*
 * CreateCompoentAction.java
 *
 * Copyright (c) 2002 Boxed-Economy Project. All right reserved. 
 */
package org.boxed_economy.besp.presentation.guifw;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.presentation.PresentationComponent;
import org.boxed_economy.besp.presentation.bface.menu.Action;

/**
 * v[e[VR|[lg𐶐邽߂̃ANVł
 * ꂽPresentationComponent̓Reiɒǉ܂B
 * AGUIComponentȂAIopen()܂
 * 
 * @author rx78g
 * @version $Id: CreateComponentAction.java,v 1.1 2004/03/21 12:07:47 macchan Exp $
 */
public class CreateComponentAction extends Action {

	private static final Logger logger =
		Logger.getLogger(CreateComponentAction.class.getName());

	private Class clazz = null;

	/**
	 * @see javax.swing.AbstractAction#AbstractAction(String)
	 */
	public CreateComponentAction(String name, Class clazz) {
		this.setName(name);
		this.clazz = clazz;
	}

	/**
	 * @see org.boxed_economy.besp.presentation.guifw.menu.Action#initialize()
	 */
	protected void initialize() {
	}

	/**
	 * @see org.boxed_economy.besp.presentation.guifw.menu.Action#doAction()
	 */
	protected void doAction() throws Exception {
		PresentationComponent component =
			(PresentationComponent) clazz.newInstance();
		this.getPresentationContainer().addPresentationComponent(component);
		if (component instanceof GUIComponent) {
			((GUIComponent) component).open();
		}
	}

}
