/*
 * ErrorDialog.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.besp.presentation.guifw;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

/**
 * G[_CAOoNX
 * OStackTrace\@\܂
 * @author macchan
 * @version $Id: ErrorDialog.java,v 1.1 2004/03/21 12:07:47 macchan Exp $
 */
public class ErrorDialog extends JPanel {

	/*******************************
	 * static
	 *******************************/

	public static final String TITLE =
		GUIContainer.resource.getString("Title_Error");
	public static final String DESCRIPTION =
		GUIContainer.resource.getString("Error_Description");
	public static final int STACKTRACEPANEL_WIDTH = 720;
	public static final int STACKTRACEPANEL_HEIGHT = 500;
	;

	public static void show(Frame owner, String message) {
		JOptionPane.showMessageDialog(
			owner,
			message,
			TITLE,
			JOptionPane.ERROR_MESSAGE);
	}

	public static void show(Frame owner, String message, Throwable throwable) {
		JOptionPane.showMessageDialog(
			owner,
			new ErrorDialog(owner, message, throwable),
			TITLE,
			JOptionPane.ERROR_MESSAGE);
	}

	/*******************************
	 * Field
	 *******************************/

	private Frame owner = null;
	private String message = null;
	private Throwable throwable = null;

	/*******************************
	 * Contructor
	 *******************************/

	private ErrorDialog(Frame owner, String message, Throwable throwable) {
		this.owner = owner;
		this.message = message;
		this.throwable = throwable;

		this.initializeComponents();
	}

	/*******************************
	 * 
	 *******************************/

	private void initializeComponents() {
		//This
		this.setLayout(new BorderLayout());

		//Label
		JLabel label = new JLabel(message);
		this.add(label, BorderLayout.NORTH);

		//Button(Panel)
		JPanel panel = new JPanel();
		panel.setLayout(new BorderLayout());
		this.add(panel, BorderLayout.EAST);

		JButton button = this.createDescriptionButton();
		panel.add(button, BorderLayout.SOUTH);

	}

	private JButton createDescriptionButton() {
		JButton button = new JButton(DESCRIPTION);
		button.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				showStackTraceDialog();
			}
		});
		return button;
	}

	/*******************************
	 * Opl֘A
	 *******************************/

	private void showStackTraceDialog() {
		JOptionPane.showMessageDialog(
			this.owner,
			this.createStackTracePanel(),
			DESCRIPTION,
			JOptionPane.PLAIN_MESSAGE);
	}

	private JPanel createStackTracePanel() {
		//pl		
		JPanel panel = new JPanel();

		//eLXgGA
		final JTextArea textArea = this.createStackTraceTextArea();

		//XN[yC				
		final JScrollPane scroller = new JScrollPane(textArea);
		scroller.setPreferredSize(
			new Dimension(STACKTRACEPANEL_WIDTH, STACKTRACEPANEL_HEIGHT));
		panel.add(scroller, null);

		//XN[Ԃԍɂ(InvokeLaterłȂ,DialogoɍĐݒ肳Ă܂)
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				scroller.getViewport().setViewPosition(new Point(0, 0));
			}
		});
		return panel;
	}

	private JTextArea createStackTraceTextArea() {
		//StackTraceByteArrayɈUfo
		ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
		PrintStream printStream = new PrintStream(outputStream);
		this.throwable.printStackTrace(printStream);

		//foꂽlƂTextArea
		JTextArea textArea = new JTextArea();
		textArea.setText(outputStream.toString());
		textArea.setEditable(false);
		return textArea;
	}
}
