package org.boxed_economy.besp.presentation.guifw;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.presentation.PresentationContainer;
import org.boxed_economy.besp.presentation.bface.GUIUtility;

/**
 * GUIComponentManagementDialog
 *
 * ݓǂݍ܂ĂGUIcomponenẗꗗ\܂B
 * `FbNꂽcomponent邱Ƃł܂B
 */
public class GUIComponentManagementDialog extends JDialog {

	private static final Logger logger =
		Logger.getLogger(GUIComponentManagementDialog.class.getName());

	private static final Color PANEL_COLOR = Color.white;
	private static final int WIDTH = 500;
	private static final int HEIGHT = 400;

	/**
	 * Reił
	 */
	private PresentationContainer presentationContainer = null;

	/**
	 * ێĂGUIcomponenẗꗗłB
	 */
	private ListItem[] guiComponents = null;

	private BorderLayout layout = new BorderLayout();
	private JPanel buttonPanel = new JPanel();
	private JScrollPane scrollPane = new JScrollPane();
	private JButton buttonAllSelect = new JButton();
	private JButton buttonClose = new JButton();
	private JButton buttonCancel = new JButton();
	private JButton buttonNoSelect = new JButton();
	private JPanel panel = new JPanel();

	/**
	* RXgN^łB
	*/
	public GUIComponentManagementDialog(
		PresentationContainer presentationContainer,
		Frame parent) {
		super(parent, true);
		this.presentationContainer = presentationContainer;

		this.initializeComponents();
		this.initializeList();
		this.initializeDialog();
	}

	/****************************
	 * 
	 ****************************/

	private void initializeDialog() {
		this.setTitle(GUIContainer.resource.getString("Title_AllClose"));
		this.setSize(WIDTH, HEIGHT);
		GUIUtility.centerWindow(this);
	}

	private void initializeComponents() {
		//pl
		panel.setBackground(PANEL_COLOR);

		//AllSelect{^
		buttonAllSelect.setText(
			GUIContainer.resource.getString("Button_AllSelect"));
		buttonAllSelect.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				selectAll(true);
			}
		});

		//uIȂv{^
		buttonNoSelect.setText(GUIContainer.resource.getString("Button_NoSelect"));
		buttonNoSelect.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				selectAll(false);
			}
		});

		//Close{^
		buttonClose.setText(GUIContainer.resource.getString("Button_Close"));
		buttonClose.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				performClose();
				exit();
			}
		});

		//LZ{^
		buttonCancel.setText(GUIContainer.resource.getString("Button_Cancel"));
		buttonCancel.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				exit();
			}
		});

		this.getContentPane().add(buttonPanel, BorderLayout.SOUTH);
		buttonPanel.add(buttonAllSelect, null);
		buttonPanel.add(buttonNoSelect, null);
		buttonPanel.add(buttonClose, null);
		buttonPanel.add(buttonCancel, null);
		this.getContentPane().add(scrollPane, BorderLayout.CENTER);
		scrollPane.getViewport().add(panel);
	}

	/**
	 * ꗗcheckBoxinitalize܂B
	 * componentmanagerIuWFNg擾GUIcomponentǉ܂B
	 */
	private void initializeList() {
		panel.setLayout(null);

		//componentListReportComponentgetĐVɃXg쐬܂B
		Vector v = new Vector();
		Iterator compoIterator =
			presentationContainer.getPresentationComponents().iterator();

		while (compoIterator.hasNext()) {
			Object o = compoIterator.next();
			if (o instanceof GUIComponent) {
				v.addElement(o);
			}
		}

		Object[] GUIcomponentList = v.toArray();
		guiComponents = new ListItem[GUIcomponentList.length];

		//NX̃IuWFNg𐶐panelɍڂB
		//(checkBox͂̂Ƃcreate)
		int panelWidth = 100; //ŏTCY
		int x = 20;
		int y = 0;
		for (int i = 0; i < guiComponents.length; i++) {
			guiComponents[i] = new ListItem((GUIComponent) GUIcomponentList[i]);
			panel.add(guiComponents[i].checkBox);
			guiComponents[i].checkBox.setLocation(x, y);

			//̑傫̒
			Dimension size = guiComponents[i].checkBox.getPreferredSize();
			guiComponents[i].checkBox.setSize(size);
			panelWidth = panelWidth > size.width ? panelWidth : size.width;
			//傫قɂ
			y = y + size.height;
		}

		panelWidth = panelWidth + 20; //Ẽ}[W
		panel.setPreferredSize(new Dimension(panelWidth, y));
		logger.debug("initializeList() end panel :x=" + panelWidth + "y=" + y);
	}

	/****************************
	 * nh
	 ****************************/

	/**
	 * uselectAllvuIȂvꂽƂɁA
	 * checkBoxׂoperate邽߂̃\bhłB
	 * @param b `FbN̐^U
	 */
	private void selectAll(boolean b) {
		int len = guiComponents.length;
		for (int i = 0; i < len; i++) {
			guiComponents[i].checkBox.setSelected(b);
		}
	}

	/**
	 * IĂ̂close܂
	 */
	private void performClose() {
		int len = this.guiComponents.length;
		for (int i = 0; i < len; i++) {
			if (guiComponents[i].checkBox.isSelected()) {
				guiComponents[i].component.close();
			}
		}
	}

	/**
	 * I܂
	 */
	private void exit() {
		dispose();
	}

	/**
	 * checkBoxcomponentт邽߂̓IuWFNgłB
	 */
	class ListItem {

		private JCheckBox checkBox = null;
		private GUIComponent component = null;

		/**
		 * IuWFNg̃RXgN^B
		 */
		ListItem(GUIComponent component) {
			checkBox = new JCheckBox(component.toString());
			checkBox.setBackground(PANEL_COLOR);
			this.component = component;
		}
	}

}
