/*
 * GUIComponentManager.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.besp.presentation.guifw;

import java.util.ArrayList;
import java.util.List;

/**
 * GUIComponentǗNX
 * @author macchan
 * @version $Id: GUIComponentManager.java,v 1.1 2004/03/21 12:07:47 macchan Exp $
 */
public class GUIComponentManager {

	private List guiComponents = new ArrayList();
	private MainFrame mainFrame = null;

	/**
	 * Constructor for GUIComponentManager.
	 */
	public GUIComponentManager(MainFrame mainFrame) {
		this.mainFrame = mainFrame;
	}

	/**
	 * GUIR|[lgǉ܂
	 */
	public void addGUIComponent(GUIComponent guiComponent) {
		if (this.guiComponents.contains(guiComponent)) {
			return; //Ɋ܂܂Ă
		}

		this.guiComponents.add(guiComponent);
		if (guiComponent instanceof AbstractInternalFrameComponent) {
			this.mainFrame.addInternalFrame(
				(AbstractInternalFrameComponent) guiComponent);
		}
	}

	/**
	 * GUIR|[lg폜܂
	 */
	public void removeGUIComponent(GUIComponent guiComponent) {
		if (!this.guiComponents.contains(guiComponent)) {
			return; //܂܂ĂȂ
		}

		this.guiComponents.remove(guiComponent);
		if (guiComponent instanceof AbstractInternalFrameComponent) {
			this.mainFrame.removeInternalFrame(
				(AbstractInternalFrameComponent) guiComponent);
		}
	}

	/**
	 * Returns the guiComponents.
	 * @return List
	 */
	public List getGUIComponents() {
		return new ArrayList(this.guiComponents);
	}

}
