/*
 * GUIContainer.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.besp.presentation.guifw;

import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;

import org.boxed_economy.besp.presentation.AbstractPresentationComponent;
import org.boxed_economy.besp.presentation.PresentationComponent;
import org.boxed_economy.besp.presentation.PresentationContainerEvent;
import org.boxed_economy.besp.presentation.PresentationContainerListener;
import org.boxed_economy.besp.presentation.bface.menu.ActionGroup;
import org.boxed_economy.besp.presentation.bface.menu.Menu;
import org.boxed_economy.besp.presentation.bface.menu.MenuElement;
import org.boxed_economy.besp.presentation.bface.menu.MenuElementGroup;

/**
 * GUIRei̎ȐӔC
 * GUIR|[lg̊Ǘ
 * 
 * MainFrame̊Ǘ
 * MenuManager̊Ǘ
 * SplashWindoẘǗ
 * 
 * Toolsj[̊Ǘ
 * Showj[̊Ǘ
 * 
 * ӔCÔ
 * t@Cj[̊ǗA
 * Rg[j[̊ǗA
 * vpeB[̊Ǘ
 * wv̊Ǘ
 * 
 * ܂AguipbP[ẂAGUIŗputilility܂܂Ă܂
 * 
 * @author macchan
 * @version $Id: GUIContainer.java,v 1.1 2004/03/21 12:07:47 macchan Exp $
 */
public class GUIContainer
	extends AbstractPresentationComponent
	implements PresentationContainerListener {

	public static ResourceBundle resource =
		ResourceBundle.getBundle(GUIContainerResource.class.getName());

	public static final String DEFAULT_ICON_IMAGE_PATH = "image/boxicon.gif";
	public static final String TITLE_IMAGE_PATH = "image/title.gif";

	private GUIComponentManager guiComponentManager = null;
	private MenuManager menuManager = null;
	private MainFrame mainFrame = null;
	private BoxSplashWindow splashWindow = null;

	/*******************************
	 * j[֘A
	 *******************************/

	//tools
	public Menu toolsMenu = new Menu();
	public MenuElementGroup toolsFirstGroup = new ActionGroup();
	public MenuElementGroup toolsDefaultGroup = new ActionGroup();
	public MenuElementGroup toolsLastGroup = new ActionGroup();

	//show
	public Menu showMenu = new Menu();
	public MenuElementGroup showFirstGroup = new ActionGroup();
	public MenuElementGroup showGeneralGroup = new ActionGroup();
	public MenuElementGroup showDefaultGroup = new ActionGroup();
	public MenuElementGroup showLastGroup = new ActionGroup();
	private ActionGroup guiComponentManagementGroup = new ActionGroup();
	public ShowDialogAction showGuiComponentManagementAction =
		new ShowDialogAction();

	/*******************************
	 * RXgN^
	 *******************************/

	/**
	 * Constructor for GUIContainer.
	 */
	public GUIContainer() {
	}

	/*******************************
	 * 
	 *******************************/

	/**
	 * @see org.boxed_economy.besp.presentation.fw.PresentationComponent#initialize()
	 */
	public void initialize() {
		//GUIR|[lg}l[W̏
		this.initializeGuiComponentManager();

		//CEChȄ
		this.initializeMainWindow();

		//j[}l[W̏
		this.initializeMenuManager();

		//j[̏
		this.initializeMenu();
	}

	private void initializeGuiComponentManager() {
		//
		this.guiComponentManager =
			new GUIComponentManager(
				this.getPresentationContainer().getMainFrame());

		//ɒǉĂ̂Ēǉ
		Iterator i =
			this
				.getPresentationContainer()
				.getPresentationComponents()
				.iterator();
		while (i.hasNext()) {
			PresentationComponent element = (PresentationComponent) i.next();
			if (element instanceof GUIComponent) {
				this.guiComponentManager.addGUIComponent(
					(GUIComponent) element);
			}
		}
	}

	private void initializeMainWindow() {
		this.getPresentationContainer().addPresentationComponent(
			this.getMainFrame());
	}

	private void initializeMenuManager() {
		this.getMenuManager().setPresentationContainer(
			this.getPresentationContainer());
		this.getMenuManager().initialize();
		this.getMainFrame().setJMenuBar(this.getMenuManager().getJMenuBar());
	}

	private void initializeMenu() {
		this.initializeToolsMenu();
		this.initializeShowMenu();
	}

	private void initializeToolsMenu() {
		this.getMenuManager().extendMenuGroup.add(this.toolsMenu);
		this.toolsMenu.setName(resource.getString("Menu_Tools"));

		//ToolsMenuO[v
		this.toolsMenu.add(this.toolsFirstGroup);
		this.toolsMenu.add(this.toolsDefaultGroup);
		this.toolsMenu.add(this.toolsLastGroup);
	}

	private void initializeShowMenu() {
		this.getMenuManager().showMenuGroup.add(this.showMenu);
		this.showMenu.setName(resource.getString("Menu_Show"));

		//ShowMenuO[v
		this.showMenu.add(this.showFirstGroup);
		this.showMenu.add(this.showGeneralGroup);
		this.showMenu.add(this.showDefaultGroup);
		this.showMenu.add(this.showLastGroup);
		this.showMenu.add(this.guiComponentManagementGroup);

		//Ǘ_CAOj[
		GUIComponentManagementDialog guiDialog =
			new GUIComponentManagementDialog(
				this.getPresentationContainer(),
				this.getMainFrame());
		this.showGuiComponentManagementAction.setDialog(guiDialog);
		this.showGuiComponentManagementAction.setName(
			resource.getString("Menu_AllClose"));
		this.guiComponentManagementGroup.add(
			this.showGuiComponentManagementAction);
	}

	/*******************************
	 * I
	 *******************************/

	/**
	 * @see org.boxed_economy.besp.presentation.fw.PresentationComponent#terminate()
	 */
	public void terminate() {
		this.getPresentationContainer().removePresentationComponent(
			this.mainFrame);
	}

	/****************************************
	 * MainWindow , MenuBar , SplashWindow֘A
	 ****************************************/
	/**
	 * MainFrame擾܂
	 */
	public MainFrame getMainFrame() {
		if (this.mainFrame == null) {
			this.mainFrame = new MainFrame();
		}
		return this.mainFrame;
	}

	/**
	 * MenuManager擾܂
	 * @return MenuManager
	 */
	public MenuManager getMenuManager() {
		if (this.menuManager == null) {
			this.menuManager = new MenuManager();
		}
		return this.menuManager;
	}

	/**
	 * SplashWindow擾܂
	 */
	public BoxSplashWindow getSplashWindow() {
		if (this.splashWindow == null) {
			this.splashWindow = new BoxSplashWindow(this.getMainFrame());
		}
		return this.splashWindow;
	}

	/****************************************
	 * Menuǉ֘Ai֗\bhj
	 ****************************************/

	/**
	 * VKj[Showj[ɒǉ܂
	 * defalutO[vɒǉ܂
	 */
	public void addMenuElementToShowMenu(MenuElement element) {
		this.showDefaultGroup.add(element);
	}

	/**
	 * VKj[Toolsj[ɒǉ܂
	 * defalutO[vɒǉ܂
	 */
	public void addMenuElementToToolsMenu(MenuElement element) {
		this.toolsDefaultGroup.add(element);
	}

	/*******************************
	 * GUIR|[lg̊Ǘ
	 *******************************/

	/**
	 * @see org.boxed_economy.besp.presentation.PresentationContainerListener#presentationComponentAdded(PresentationContainerEvent)
	 */
	public void presentationComponentAdded(PresentationContainerEvent ev) {
		PresentationComponent component = ev.getPresentationComponent();
		if (component instanceof GUIComponent) {
			this.guiComponentManager.addGUIComponent((GUIComponent) component);
		}
	}

	/**
	 * @see org.boxed_economy.besp.presentation.PresentationContainerListener#presentationComponentRemoved(PresentationContainerEvent)
	 */
	public void presentationComponentRemoved(PresentationContainerEvent ev) {
		PresentationComponent component = ev.getPresentationComponent();
		if (component instanceof GUIComponent) {
			this.guiComponentManager.removeGUIComponent(
				(GUIComponent) component);
		}
	}

	/**
	 * Returns the guiComponents.
	 * @return List
	 */
	public List getGUIComponents() {
		return this.guiComponentManager.getGUIComponents();
	}

}
