/*
 * MainFrame.java
 *
 * Copyright (c) 2002 Boxed-Economy Project. All right reserved. 
 */
package org.boxed_economy.besp.presentation.guifw;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Arrays;

import javax.swing.JDesktopPane;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.container.BESP;

/**
 * BESP̃Ct[
 * ̃NX̐ӔC
 * fXNgbv̊Ǘ(InternalFrame̒ǉƍ폜)
 * Xe[^Xo[̊Ǘ()
 * 
 * @author rx78g
 * @version $Id: MainFrame.java,v 1.1 2004/03/21 12:07:47 macchan Exp $
*/
public class MainFrame extends AbstractFrameComponent {

	private static final Logger logger =
		Logger.getLogger(MainFrame.class.getName());

	private static final Color DESKTOP_BG_COLOR = Color.white; //fXNgbv̔wiF
	private static final String TITLE = "Boxed Economy Simulation Platform";

	/*************************
	 * tB[h
	 *************************/

	/**
	* JDesktopPane.
	*/
	private JDesktopPane desktop = new JDesktopPane();

	/*************************
	 * RXgN^
	 *************************/

	/**
	 * RXgN^łB
	 */
	public MainFrame() {
	}

	/*************************
	 * 
	 *************************/

	/**
	 * ݒ܂ioverride)
	 */
	protected void initializeWindow() {
		//XvbV̂߁AMainWindow̏͒x点
	}

	/**
	 * @see org.boxed_economy.besp.presentation.fw.PresentationComponent#initialize()
	 */
	public void initialize() {
		this.initializeFrame();
		this.initializeDefaultCloseOperation();
		this.initializeIcon();
		this.initizalizeDesktop();
		this.loadProperty();
	}

	/**
	 * @see org.boxed_economy.besp.presentation.fw.AbstractFrameComponent#initializeWindow()
	 */
	protected void initializeFrame() {
		//^Cg
		this.setTitle(TITLE);

		//傫߂܂
		Dimension screenSize = this.getToolkit().getScreenSize().getSize();
		Dimension windowSize =
			new Dimension(screenSize.width - 100, screenSize.height - 100);
		this.setSize(windowSize);
		this.setLocation(50, 20);
	}

	/**
	 * @see org.boxed_economy.besp.presentation.fw.AbstractFrameComponent#initializeDefaultCloseOperation()
	 */
	protected void initializeDefaultCloseOperation() {
		this.setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
		this.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				BESP.terminate();
			}
		});
	}

	private void initizalizeDesktop() {
		desktop.setBackground(DESKTOP_BG_COLOR);
		this.getContentPane().add(desktop);
	}

	/*************************
	 * I
	 *************************/

	/**
	 * @see org.boxed_economy.besp.presentation.fw.PresentationComponent#terminate()
	 */
	public void terminate() {
		this.saveProperty();
	}

	/*************************
	 * fXNgbv֘A
	 *************************/

	void addInternalFrame(AbstractInternalFrameComponent internalFrame) {
		if (internalFrame instanceof ParetteLayerInternalFrame) {
			this.desktop.add(internalFrame, JDesktopPane.PALETTE_LAYER, 0);
		}
		else {
			this.desktop.add(internalFrame, 0);
		}
	}

	void removeInternalFrame(AbstractInternalFrameComponent internalFrame) {
		if (Arrays.asList(this.desktop.getComponents()).contains(internalFrame)) {
			this.desktop.remove(internalFrame);
		}
	}

	/*************************
	 * ۑ֘A
	 *************************/
	private void saveProperty() {
		MainFrameProperty property = new MainFrameProperty();
		property.state = this.getState();
		property.bounds = this.getBounds();
		BESP.property.put(this.getClass(), property);
	}

	private void loadProperty() {
		MainFrameProperty property =
			(MainFrameProperty) BESP.property.get(this.getClass());
		if (property != null) {
			this.setBounds(property.bounds);
			this.setState(property.state);
		}
	}

}

class MainFrameProperty implements Serializable {
	int state = 0;
	Rectangle bounds = null;
}
