/*
 * ShowGUIComponentAction.java
 *
 * Copyright (c) 2002 Boxed-Economy Project. All right reserved. 
 */
package org.boxed_economy.besp.presentation.guifw;

import javax.swing.JFrame;
import javax.swing.JInternalFrame;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.presentation.bface.menu.Action;

/**
 * GUIR|[lgJ߂̃NXłB
 * ɃVOgGUIR|[lgŁAĂEChEopen()邽߂Ɏg܂B
 * VOgGUIR|[lgΏۂƂ邽߁AI			
 * frame.setDefaultCloseOperation(JInternalFrame.HIDE_ON_CLOSE);
 * ݒ肪s܂
 * 
 * VGUIR|[lg쐬ɂ́ACreateComponentAction𗘗pĉ
 * 
 * @author rx78g
 * @version $Id: ShowGUIComponentAction.java,v 1.1 2004/03/21 12:07:47 macchan Exp $
 */
public class ShowGUIComponentAction extends Action {

	private static final Logger logger =
		Logger.getLogger(ShowGUIComponentAction.class.getName());

	private GUIComponent guiComponent = null;
	private Class guiComponentClass = null;

	/**
	 * GUIR|[lĝ̂ɂƂRXgN^
	 * p[^̂܂܃VOgIuWFNgɂȂ܂
	 * @param name
	 * @param guiComponent
	 */
	public ShowGUIComponentAction(String name, GUIComponent guiComponent) {
		this.setName(name);
		this.guiComponent = guiComponent;
	}

	/**
	 * GUIR|[lg̃NXɂƂRXgN^
	 * ĂяoɈ܂
	 * @param name
	 * @param guiComponent
	 */
	public ShowGUIComponentAction(String name, Class guiComponentClass) {
		this.setName(name);
		this.guiComponentClass = guiComponentClass;
	}

	/**
	 * @see org.boxed_economy.besp.presentation.guifw.menu.Action#initialize()
	 */
	protected void initialize() {
	}

	/**
	 * GUIR|[lg𐶐܂
	 */
	private void createGUIComponent() throws Exception {
		this.guiComponent = (GUIComponent) this.guiComponentClass.newInstance();
	}

	/**
	 * CoseOperation̐ݒs܂
	 * DISPOSEEXITȂ狭IHIDE֕ύX܂
	 * iDO_NOTHINGȂ牽܂j
	 */
	private void setCloseOperation() throws Exception {
		if (this.guiComponent instanceof JFrame) {
			int closeOperation =
				((JFrame) this.guiComponent).getDefaultCloseOperation();
			if (closeOperation == JFrame.DISPOSE_ON_CLOSE
				|| closeOperation == JFrame.EXIT_ON_CLOSE);
			((JFrame) this.guiComponent).setDefaultCloseOperation(
				JFrame.HIDE_ON_CLOSE);
		}
		else if (this.guiComponent instanceof JInternalFrame) {
			int closeOperation =
				((JInternalFrame) this.guiComponent).getDefaultCloseOperation();
			if (closeOperation == JInternalFrame.DISPOSE_ON_CLOSE
				|| closeOperation == JInternalFrame.EXIT_ON_CLOSE);
			((JInternalFrame) this.guiComponent).setDefaultCloseOperation(
				JInternalFrame.HIDE_ON_CLOSE);
		}
	}

	/**
	 * AReiɓo^ĂȂAo^܂
	 */
	private void addToContainer() throws Exception {
		if (!this
			.getPresentationContainer()
			.getPresentationComponents()
			.contains(this.guiComponent)) {
			this.getPresentationContainer().addPresentationComponent(
				this.guiComponent);
		}
	}

	/**
	 * @see org.boxed_economy.besp.presentation.guifw.menu.Action#doAction()
	 */
	protected void doAction() throws Exception {
		if (this.guiComponent == null) {
			this.createGUIComponent();
		}
		this.setCloseOperation();
		this.addToContainer();
		this.guiComponent.open();
	}

}
