/*
 * BoxLF5Appender.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.boxlf5;

import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.lf5.Log4JLogRecord;
import org.apache.log4j.lf5.LogLevel;
import org.apache.log4j.lf5.LogLevelFormatException;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;

/**
 * @author macchan
 * @version $Id: BoxLF5Appender.java,v 1.1 2004/03/21 12:07:48 macchan Exp $
 */
public class BoxLF5Appender extends AppenderSkeleton {

	/*********
	 * static
	 *********/

	private static BoxLF5LogBrokerMonitor monitor = null;
	private static boolean active = true;

	private static void initializeMonitor() {
		if (monitor == null) {
			monitor = new BoxLF5LogBrokerMonitor(LogLevel.getLog4JLevels());
		}
	}

	public static BoxLF5LogBrokerMonitor getMonitor() {
		return monitor;
	}

	public static void setActive(boolean active) {
		BoxLF5Appender.active = active;
	}

	public static boolean isActive() {
		return active;
	}

	/************
	 * active֘A
	 ************/

	/**
	 * Constructor for BoxLF5Appender.
	 */
	public BoxLF5Appender() {
		initializeMonitor();
	}

	/****************
	 * Appender̎
	 ****************/

	/**
	 * @see org.apache.log4j.AppenderSkeleton#append(LoggingEvent)
	 */
	protected void append(LoggingEvent event) {
		if (!isActive()) {
			return;
		}

		if (monitor != null) {
			Log4JLogRecord record = this.createRecord(event);
			monitor.addMessage(record);
		}
	}

	/**
	 * LF5AppenderRs[
	 */
	protected Log4JLogRecord createRecord(LoggingEvent event) {
		// Retrieve the information from the log4j LoggingEvent.
		String category = event.categoryName;
		String logMessage = event.getRenderedMessage();
		String nestedDiagnosticContext = event.getNDC();
		String threadDescription = event.getThreadName();
		String level = event.level.toString();
		long time = event.timeStamp;
		LocationInfo locationInfo = event.getLocationInformation();

		// Add the logging event information to a LogRecord
		Log4JLogRecord record = new Log4JLogRecord();

		record.setCategory(category);
		record.setMessage(logMessage);
		record.setLocation(locationInfo.fullInfo);
		record.setMillis(time);
		record.setThreadDescription(threadDescription);

		if (nestedDiagnosticContext != null) {
			record.setNDC(nestedDiagnosticContext);
		} else {
			record.setNDC("");
		}

		if (event.getThrowableInformation() != null) {
			record.setThrownStackTrace(event.getThrowableInformation());
		}

		try {
			record.setLevel(LogLevel.valueOf(level));
		} catch (LogLevelFormatException e) {
			// If the priority level doesn't match one of the predefined
			// log levels, then set the level to warning.
			record.setLevel(LogLevel.WARN);
		}
		return record;
	}

	/**
	 * @see org.apache.log4j.Appender#close()
	 */
	public void close() {
	}

	/**
	 * @see org.apache.log4j.Appender#requiresLayout()
	 */
	public boolean requiresLayout() {
		return false;
	}

}
