/*
 * BoxLF5LogBrokerMonitor.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.boxlf5;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.util.List;

import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;

import org.apache.log4j.lf5.viewer.LogBrokerMonitor;
import org.apache.log4j.lf5.viewer.LogTable;
import org.apache.log4j.lf5.viewer.TrackingAdjustmentListener;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryExplorerTree;
import org.apache.log4j.lf5.viewer.configure.ConfigurationManager;
import org.apache.log4j.lf5.viewer.configure.MRUFileManager;
import org.boxed_economy.besp.presentation.PresentationContainer;

/**
 * @author macchan
 * @version $Id: BoxLF5LogBrokerMonitor.java,v 1.1 2004/03/21 12:07:48 macchan Exp $
 */
public class BoxLF5LogBrokerMonitor extends LogBrokerMonitor {

	//--------------------------------------------------------------------------
	//   Static:
	//--------------------------------------------------------------------------	
	static {
		PresentationContainer.initializeLookAndFeel();
	}

	//--------------------------------------------------------------------------
	//   Field:
	//--------------------------------------------------------------------------	

	private PresentationContainer container = null;

	//super()ő邽=null͏Ă͂Ȃ
	private BoxLF5InternalFrameComponent internalFrame;

	//--------------------------------------------------------------------------
	//   Constructors:
	//--------------------------------------------------------------------------

	/**
	 * Construct a LogBrokerMonitor.
	 */
	public BoxLF5LogBrokerMonitor(List logLevels) {
		super(logLevels);
	}

	//--------------------------------------------------------------------------
	//  Container֘A
	//--------------------------------------------------------------------------	

	public void setContainer(PresentationContainer container) {
		this.container = container;
	}

	//--------------------------------------------------------------------------
	//   InternalFrame̐
	//--------------------------------------------------------------------------	
	public BoxLF5InternalFrameComponent createInternalFrameComponent() {
		BoxLF5InternalFrameComponent frame = new BoxLF5InternalFrameComponent();
		frame.setTitle("Log Window");
		return frame;
	}

	//--------------------------------------------------------------------------
	//   Frame֘A (Override)
	//--------------------------------------------------------------------------

	public void show(final int delay) {
		this.internalFrame.show();
	}

	public void dispose() {
		this.hide();
	}

	protected void closeAfterConfirm() {
		this.hide();
	}

	public void hide() {
		this.internalFrame.hide();
	}

	public void setTitle(String title) {
		this.internalFrame.setTitle(title + " - LogFactor5");
	}

	protected void updateFrameSize() {
		this.internalFrame.setSize(_logMonitorFrameWidth, _logMonitorFrameHeight);
		this.centerFrame(this.internalFrame);
	}

	public BoxLF5InternalFrameComponent getInternalFrame() {
		return this.internalFrame;
	}

	public JFrame getBaseFrame() {
		if (this.container == null) {
			return null;
		}
		return this.container.getMainFrame();
	}

	/**
	 * t[𒆉(V\bh)
	 */
	protected void centerFrame(JInternalFrame frame) {
		if (this.getBaseFrame() != null) {
			Dimension screen = this.getBaseFrame().getSize();
			Dimension comp = frame.getSize();

			frame.setLocation(
				((screen.width - comp.width) / 2),
				((screen.height - comp.height) / 2));
		}
	}

	//--------------------------------------------------------------------------
	//  initialize (Override)
	//--------------------------------------------------------------------------	

	/**
	 * Configure the Frame.
	 * InternalFrameɂȂ悤ɕύX
	 */
	protected void initComponents() {

		_logMonitorFrame = new JFrame("LogFactor5"); //super()ŎQƂĂ邽߃_~[Ă

		this.internalFrame = this.createInternalFrameComponent();
		this.internalFrame.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);

		updateFrameSize();

		//
		// Configure the LogTable.
		//
		JTextArea detailTA = createDetailTextArea();
		JScrollPane detailTAScrollPane = new JScrollPane(detailTA);
		_table = new LogTable(detailTA);
		setView(_currentView, _table);
		_table.setFont(new Font(_fontName, Font.PLAIN, _fontSize));
		_logTableScrollPane = new JScrollPane(_table);

		if (_trackTableScrollPane) {
			_logTableScrollPane.getVerticalScrollBar().addAdjustmentListener(
				new TrackingAdjustmentListener());
		}

		// Configure the SplitPane between the LogTable & DetailTextArea
		//

		JSplitPane tableViewerSplitPane = new JSplitPane();
		tableViewerSplitPane.setOneTouchExpandable(true);
		tableViewerSplitPane.setOrientation(JSplitPane.VERTICAL_SPLIT);
		tableViewerSplitPane.setLeftComponent(_logTableScrollPane);
		tableViewerSplitPane.setRightComponent(detailTAScrollPane);
		// Make sure to do this last..
		//tableViewerSplitPane.setDividerLocation(1.0); Doesn't work
		//the same under 1.2.x & 1.3
		// "350" is a magic number that provides the correct default
		// behaviour under 1.2.x & 1.3.  For example, bumping this
		// number to 400, causes the pane to be completely OPEN in 1.2.x
		// and closed in 1.3
		tableViewerSplitPane.setDividerLocation(350);

		//
		// Configure the CategoryExplorer
		//

		_categoryExplorerTree = new CategoryExplorerTree();

		_table.getFilteredLogTableModel().setLogRecordFilter(
			createLogRecordFilter());

		JScrollPane categoryExplorerTreeScrollPane =
			new JScrollPane(_categoryExplorerTree);
		categoryExplorerTreeScrollPane.setPreferredSize(new Dimension(130, 400));

		// Load most recently used file list
		_mruFileManager = new MRUFileManager();

		//
		// Configure the SplitPane between the CategoryExplorer & (LogTable/Detail)
		//

		JSplitPane splitPane = new JSplitPane();
		splitPane.setOneTouchExpandable(true);
		splitPane.setRightComponent(tableViewerSplitPane);
		splitPane.setLeftComponent(categoryExplorerTreeScrollPane);
		// Do this last.
		splitPane.setDividerLocation(130);
		//
		// Add the MenuBar, StatusArea, CategoryExplorer|LogTable to the
		// LogMonitorFrame.
		//
		this.internalFrame.getRootPane().setJMenuBar(createMenuBar());
		this.internalFrame.getContentPane().add(splitPane, BorderLayout.CENTER);
		this.internalFrame.getContentPane().add(
			createToolBar(),
			BorderLayout.NORTH);
		this.internalFrame.getContentPane().add(
			createStatusArea(),
			BorderLayout.SOUTH);

		makeLogTableListenToCategoryExplorer();
		addTableModelProperties();

		//
		// Configure ConfigurationManager
		//
		_configurationManager = new ConfigurationManager(this, _table);

	}

	/**
	 * C
	 */
	protected void updateMRUList() {
		//C		JMenu menu = _logMonitorFrame.getJMenuBar().getMenu(0);
		JMenu menu = this.internalFrame.getJMenuBar().getMenu(0); //V
		menu.removeAll();
		menu.add(createOpenMI());
		menu.add(createOpenURLMI());
		menu.addSeparator();
		menu.add(createCloseMI());
		createMRUFileListMI(menu);
		menu.addSeparator();
		menu.add(createExitMI());
	}

}
