/*
 * BoxLF5Plugin.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.boxlf5;

import org.boxed_economy.besp.container.BESPContainer;
import org.boxed_economy.besp.container.BESPPlugin;
import org.boxed_economy.besp.presentation.PresentationContainer;
import org.boxed_economy.besp.presentation.guifw.ShowGUIComponentAction;
import org.boxed_economy.besp.presentation.bface.menu.ActionGroup;

/**
 * @author macchan
 * @version $Id: BoxLF5Plugin.java,v 1.1 2004/03/21 12:07:48 macchan Exp $
 */
public class BoxLF5Plugin implements BESPPlugin {

	private static BoxLF5LogBrokerMonitor monitor = null;

	private static ActionGroup logGroup = new ActionGroup();
	private static ShowGUIComponentAction logShowAction = null;
	private static BoxLF5InternalFrameComponent frame = null;

	public static void initializePlugin(BESPContainer container) {
		initializeMonitor(container.getPresentationContainer());
		initializeMenu(container.getPresentationContainer());
	}

	private static void initializeMonitor(PresentationContainer pContainer) {
		if (BoxLF5Appender.getMonitor() != null) {
			//Create Monitor
			BoxLF5LogBrokerMonitor monitor = BoxLF5Appender.getMonitor();
			monitor.setContainer(pContainer);
			monitor.setFrameSize(800, 600);
			monitor.setFontSize(12);
			frame = monitor.getInternalFrame();
		}
	}

	private static void initializeMenu(PresentationContainer pContainer) {
		pContainer.getGuiContainer().showFirstGroup.add(logGroup);
		logShowAction = new ShowGUIComponentAction("Log", frame);
		logGroup.add(logShowAction);

		if (BoxLF5Appender.getMonitor() != null) {
			logGroup.setEnabled(true);
		}
		else {
			logGroup.setEnabled(false);
		}
	}

}
