package org.boxed_economy.components.cell;

import org.boxed_economy.besp.model.ModelException;
import org.boxed_economy.besp.model.fmfw.Information;

/**
 * PZ\NXłBQZȂ̂ŁAwCxWvZ
 * Ƃł܂B
 * 
 * @author Yc & Macchan
 * @version $Id: Cell.java,v 1.1 2004/03/21 12:07:47 macchan Exp $
 */
public class Cell implements Information {

	/**
	* vZ鎞intX,Ylocation^܂AQ悵inťEl𒴂
	* value^ƐmȌvZs\Ȃ̂ŁAint̍ől̕ZW̍ől
	* ɐݒ肵Ă܂B
	*/
	private final int MAX_LOCATION =
		(int) Math.round(Math.sqrt(Integer.MAX_VALUE));

	private int x;
	private int y;

	/**
	 * Constructor for Cell.
	 */
	public Cell(int x, int y) {
		this.x = x;
		this.y = y;
	}

	/**
	 * ZXWԂ܂B
	 * @return int ZXW
	 */
	public int getX() {
		return x;
	}

	/**
	 * ZYWԂ܂B
	 * @return int ZYW
	 */
	public int getY() {
		return y;
	}

	/**
	* targetƂ̋vZĕԂ܂B
	* Javaint^̐z悤ȋvZ邱Ƃ͂ł܂B
	* @param target targetlocation
	* @return 茋
	*/
	public double measureDistance(Cell target) {
		if (Math.abs(this.x - target.x) + Math.abs(this.y - target.y)
			>= MAX_LOCATION) {
			throw new ModelException("DefaultLocation#getDistance inťEl𒴂邽߁A46341ȏ㗣ĂZ̋𑪒肷邱Ƃ͂ł܂B");
		}

		// O̒藝ŋlength擾܂B
		double length =
			Math.sqrt(
				Math.pow(this.x - target.x, 2)
					+ Math.pow(this.y - target.y, 2));

		return length;
	}

	/**
	 * @see java.lang.Object#equals(Object)
	 */
	public boolean equals(Object o) {
		if (!(o instanceof Cell)) {
			return false;
		}
		Cell another = (Cell) o;
		return x == another.x && y == another.y;
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return "(" + x + "," + y + ")";
	}

}
