/**
 * CellAgentComponent.java
 *
 * Copyright (c) 2002 Boxed-Economy Project. All right reserved. 
 */
package org.boxed_economy.components.cell;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.JComponent;

/**
 * @author rx78g
 * @version $Id: CellAgentComponent.java,v 1.1 2004/03/21 12:07:47 macchan Exp $
 */
public class CellAgentComponent extends JComponent {

	private CellFieldPanel parent;
	private Color foreColor = Color.BLUE;

	/**
	* Constructor for CellAgentComponent.
	*/
	public CellAgentComponent(CellFieldPanel parent) {
		super();
		this.parent = parent;

	}

	protected void paintComponent(Graphics g) {
		this.setPreferredSize(
			new Dimension(parent.getCellSize(), parent.getCellSize()));
		g.fillOval(0, 0, parent.getCellSize(), parent.getCellSize());
	}

	protected void mouseClicked(MouseEvent e) {
		System.out.println("Clicked");
	}

	class CellAgentComponent_mouseAdapter extends MouseAdapter {
		protected CellAgentComponent adaptee;

		CellAgentComponent_mouseAdapter(CellAgentComponent adaptee) {
			this.adaptee = adaptee;
		}
		public void mouseClicked(MouseEvent e) {
			adaptee.mouseClicked(e);
		}
	}
}