package org.boxed_economy.components.cell;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;

import javax.swing.JPanel;

/**
 * CellSpacȅ\邽߂̃plłBeR|[lgɂ
 * ̃NXpCellSpace`pl쐬ĂB
 * v[e[VR|[lgł͂܂B
 * 
 * @author Boxed Economy Project & Numeric Co,Ltd.
 * @version $Id: CellFieldPanel.java,v 1.1 2004/03/21 12:07:47 macchan Exp $
 */
public abstract class CellFieldPanel extends JPanel {

	private CellSpace cellSpace;

	private int cellSize = 10; //Zӂ̑傫
	private Color bgColor = Color.WHITE; //Z̔wiF
	private boolean writeBorder = true; //iq`悷邩H
	private Color foreColor = Color.BLACK; //iq̕`F
	private boolean isValidData = false; //`Ώۂ̋Ԃf[^

	/**
	 * O炱̃pl`悷邽߂ɌĂ΂郁\bhłB
	 */
	public final void drawField() {
		//f[^ł邩̃`FbNs܂B
		if (cellSpace == null
			|| cellSpace.getXCellNum() < 1
			|| cellSpace.getYCellNum() < 1
			|| cellSize > 0) {
			isValidData = false;
		}
		isValidData = true;
		revalidate();
		repaint();
	}

	/**
	 * @see javax.swing.JComponent#paintComponent(Graphics)
	 */
	protected void paintComponent(Graphics g) {
		//Af[^łȂ΁A̎|\܂B
		if (!isValidData) {
			this.setPreferredSize(new Dimension(100, 40));
			this.setBackground(Color.white);
			g.setColor(Color.red);
			g.drawString("Invalid Space", 20, 20);
			return;
		}

		this.setPreferredSize(
			new Dimension(
				cellSpace.getXCellNum() * cellSize,
				cellSpace.getYCellNum() * cellSize));

		drawBackGround(g);
		if (writeBorder) {
			drawBorder(g);
		}
		drawAgents(g);
		drawOthers(g);
	}

	/**
	 * wi`悵܂BftHgł͐ݒ肵wiFœh܂A
	 * R|[lg쐬҂I[o[Chł܂B
	 * 
	 * @param g
	 */
	protected void drawBackGround(Graphics g) {
		g.setColor(this.getBgColor());
		g.fillRect(
			0,
			0,
			cellSpace.getYCellNum() * getCellSize(),
			cellSpace.getXCellNum() * getCellSize());
	}
	/**
	 * iq`悵܂BftHgł͐ݒ肵FŊiq`悵܂A
	 * R|[lg쐬҂I[o[Chł܂B
	 */
	protected void drawBorder(Graphics g) {
		g.setColor(getForeColor());
		for (int i = 0; i <= cellSpace.getYCellNum(); i++) {
			g.drawLine(
				0,
				i * getCellSize(),
				cellSpace.getYCellNum() * getCellSize(),
				i * getCellSize());
		}
		for (int j = 0; j <= cellSpace.getXCellNum(); j++) {
			g.drawLine(
				j * getCellSize(),
				0,
				j * getCellSize(),
				cellSpace.getXCellNum() * getCellSize());
		}
	}

	/**
	 * Agent`悵܂BR|[lg쐬҂I[o[ChĂB
	 * @param g
	 */
	protected abstract void drawAgents(Graphics g);

	/**
	 * ̑relation`悵܂BKv΃R|[lg쐬҂I[o[ChĂB
	 * @param g
	 */
	protected void drawOthers(Graphics g) {

	}

	/**
	 * Method setCellSpace.
	 * @param cellSpace
	 */
	public void setCellSpace(CellSpace cellSpace) {
		this.cellSpace = cellSpace;
		drawField();
	}

	/**
	 * Returns the cellSpace.
	 * @return CellSpace
	 */
	public CellSpace getCellSpace() {
		return cellSpace;
	}

	/**
	 * Returns the cellSize.
	 * @return int
	 */
	public int getCellSize() {
		return cellSize;
	}

	/**
	 * Sets the cellSize.
	 * @param cellSize The cellSize to set
	 */
	public void setCellSize(int cellSize) {
		this.cellSize = cellSize;
		drawField();
	}

	/**
	 * Returns the bgColor.
	 * @return Color
	 */
	public Color getBgColor() {
		return bgColor;
	}

	/**
	 * Returns the foreColor.
	 * @return Color
	 */
	public Color getForeColor() {
		return foreColor;
	}

	/**
	 * Sets the bgColor.
	 * @param bgColor The bgColor to set
	 */
	public void setBgColor(Color bgColor) {
		this.bgColor = bgColor;
		drawField();
	}

	/**
	 * Sets the foreColor.
	 * @param foreColor The foreColor to set
	 */
	public void setForeColor(Color foreColor) {
		this.foreColor = foreColor;
		drawField();
	}

	/**
	 * Returns the writeBorder.
	 * @return boolean
	 */
	public boolean isWriteBorder() {
		return writeBorder;
	}

	/**
	 * Sets the writeBorder.
	 * @param writeBorder The writeBorder to set
	 */
	public void setWriteBorder(boolean writeBorder) {
		this.writeBorder = writeBorder;
		drawField();
	}

	/**
	 * Returns the isValidData.
	 * @return boolean
	 */
	public boolean isValidData() {
		return isValidData;
	}

	/**
	 * Sets the isValidData.
	 * @param isValidData The isValidData to set
	 */
	public void setIsValidData(boolean isValidData) {
		this.isValidData = isValidData;
		drawField();
	}

}
