package org.boxed_economy.components.cell;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import org.boxed_economy.besp.model.ModelException;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.Space;

/**
 * SpacepāAZԂ`܂BcL̃Z\
 * Space`܂B̃ZԂɂ̓G[WFgzu邱Ƃł܂B
 * ̃NXł̓ZƃG[WFg̑ΉێA擾\ɂ邱ƂŁA
 * G[WFg̔zu`Ă܂B̃Zɕ̃G[WFgzu
 * Ƃ\łB
 * 
 * @author Boxed Economy Project & Numeric Co,Ltd.
 * @version $Id: CellSpace.java,v 1.1 2004/03/21 12:07:47 macchan Exp $
 */
public class CellSpace implements Space {

	private int xCellNum;
	private int yCellNum;
	private boolean isLoop = true;

	//CellG[WFg߂̃Xgz
	private List[][] cellList;
	//G[WFgCell߂HashTable	
	private Map agentList = new HashMap();

	/**
	 * RXgN^łB傫Ɗ߂̗Lw肵Đ܂B
	 * 
	 * @param xCellNum
	 * @param yCellNum
	 * @param isRound
	 */
	public CellSpace(int xCellNum, int yCellNum, boolean isRound) {
		this.xCellNum = xCellNum;
		this.yCellNum = yCellNum;
		this.isLoop = isRound;
		cellList = new List[xCellNum][yCellNum];
	}

	/**
	 * G[WFgړ邽߂̃\bhłB
	 * G[WFgɑΉCellu܂B
	 * AsCellړƂė^ꍇAExceptionԂ܂B
	 * 
	 * @param agent ړG[WFg
	 * @param newCell ړCell
	 */
	public void moveAgent(Agent agent, Cell newCell) {
		//O`FbN
		if (!xyRangeValid(newCell.getX(), newCell.getY())) {
			throw new ModelException(
				"Invalid Cell (" + newCell.getX() + "," + newCell.getY() + ")");
		}

		removeAgent(agent);
		addAgent(agent, newCell.getX(), newCell.getY());
	}

	/**
	 * x,y̍WCellɃG[WFgǉ܂B
	 * ǉ̍WsłꍇA܂̓G[WFgSĂǂ
	 * zuĂꍇAExceptionԂ܂B
	 * 
	 * @param agent
	 * @param x
	 * @param y 
	 */
	public void addAgent(Agent agent, int x, int y) {
		//O`FbN
		if (!xyRangeValid(x, y)) {
			throw new ModelException("Invalid Cell(" + x + "," + y + ")");
		}
		if (this.agentList.containsKey(agent) == true) {
			throw new ModelException("Already Agent exist !");
		}

		//ʒuXgɃG[WFgǉ
		if (this.cellList[x][y] == null) {
			this.cellList[x][y] = new LinkedList();
		}
		this.cellList[x][y].add(agent);

		//G[WFgXgɈʒuǉ
		this.agentList.put(agent, new Cell(x, y));
	}

	/**
	 * SpaceAgent폜܂B
	 * @param agent
	 */
	public void removeAgent(Agent agent) {
		//O`FbN
		if (this.agentList.containsKey(agent) == false) {
			throw new ModelException("Agent is not exist in AgentList");
		}
		Cell cell = (Cell) this.agentList.get(agent);
		if (this.cellList[cell.getX()][cell.getY()].contains(agent) == false) {
			throw new ModelException("Agent is not exist in CellList");
		}

		//{
		this.agentList.remove(agent);
		this.cellList[cell.getX()][cell.getY()].remove(agent);

		//`FbN
		if (this.agentList.containsKey(agent) == true) {
			throw new ModelException("Agent is exist in AgentList yet");
		}
		if (this.cellList[cell.getX()][cell.getY()].contains(agent) == true) {
			throw new ModelException("Agent is exist in CellList yet");
		}

	}

	/**
	 * G[WFĝCell܂B̃G[WFg݂̑CellԂ܂B
	 * 
	 * @param agent
	 * @return Cell
	 */
	public Cell getCell(Agent agent) {
		//O`FbN
		if (this.agentList.containsKey(agent) == false) {
			throw new ModelException("̂悤ȃG[WFg݂͑܂");
		}

		return (Cell) this.agentList.get(agent);
	}

	/**
	 * ZɂG[WFg܂B
	 * CellɊ֘AtĂAgentCollectionԂ܂B
	 * 
	 * @param cell
	 * @return Collection
	 */
	public Collection getAgents(Cell cell) {
		//Ȃꍇ́ÃXgԂ
		if (this.cellList[cell.getX()][cell.getY()] == null) {
			return new ArrayList();
		}

		return new ArrayList(this.cellList[cell.getX()][cell.getY()]);
	}

	/**
	 * ZɂG[WFg܂B
	 * x,yWCellɊ֘AtĂAgentCollectionԂ܂B
	 * 
	 * @param x
	 * @param y
	 * @return Collection
	 */
	public Collection getAgents(int x, int y) {
		return getAgents(new Cell(x, y));
	}

	/**
	 * G[WFgƃXR[vYZ擾܂B
	 * 
	 * @param centerAgent XR[v̒S̃G[WFg
	 * @param scope ̃G[WFg̃XR[v
	 * @return Collection YZ̏W
	 */
	public Collection getCells(Agent centerAgent, CellScope scope) {

		//ʃZ[郊Xg
		List cellList = new ArrayList();

		//SZƑ΃ZXg擾
		Cell centerCell = getCell(centerAgent);
		List relativeCells = scope.getRelativeCells();

		//΃Z΃Zɕϊ
		Iterator i = relativeCells.iterator();
		while (i.hasNext()) {
			Cell relativeCell = (Cell) i.next();
			Cell absoluteCell = null;

			//Z񂷂
			if (this.isLoop) {
				absoluteCell = getAbsoluteCellRound(centerCell, relativeCell);
			}
			//Z񂵂Ȃ
			else {
				absoluteCell = getAbsoluteCellNotRound(centerCell, relativeCell);
			}

			if (absoluteCell != null) {
				cellList.add(absoluteCell);
			}
		}

		return cellList;
	}

	/**
	 * G[WFgƃXR[vYG[WFg擾܂B
	 * 
	 * @param centerAgent XR[v̒S̃G[WFg
	 * @param scope ̃G[WFg̃XR[v
	 * @return Collection YG[WFg̏W
	 */
	public Collection getAgents(Agent centerAgent, CellScope scope) {
		List agents = new ArrayList();
		Iterator i = this.getCells(centerAgent, scope).iterator();
		while (i.hasNext()) {
			Cell element = (Cell) i.next();
			agents.addAll(this.getAgents(element));
		}
		return agents;
	}

	/**
	 * ̍WCellԂ܂B
	 * 
	 * @param x
	 * @param y
	 * @return Cell
	 */
	public Cell getCell(int x, int y) {
		return new Cell(x, y);
	}

	/**
	 * ̋Ԃɑ݂G[WFgԂ܂B
	 * 
	 * @return int
	 */
	public int getAgentCount() {
		return agentList.size();
	}

	/**
	 * ̋Ԃ̉̍LԂ܂B
	 * @return int
	 */
	public int getXCellNum() {
		return xCellNum;
	}

	/**
	 * ̋Ԃ̏c̍LԂ܂B
	 * @return int
	 */
	public int getYCellNum() {
		return yCellNum;
	}

	/**
	 * ΃Z߂
	 * iZ񂵂Ȃꍇj
	 */
	private Cell getAbsoluteCellRound(Cell center, Cell relative) {
		int x = center.getX() + relative.getX();
		int y = center.getY() + relative.getY();

		while (x < 0) {
			x = x + this.xCellNum;
		}
		x = x % this.xCellNum;

		while (y < 0) {
			y = y + this.yCellNum;
		}
		y = y % this.yCellNum;

		return new Cell(x, y);
	}

	/**
	 * ΃Z߂
	 * iZ񂵂Ȃꍇj
	 */
	private Cell getAbsoluteCellNotRound(Cell center, Cell relative) {
		int x = center.getX() + relative.getX();
		int y = center.getY() + relative.getY();
		if (xyRangeValid(x, y)) {
			return new Cell(x, y);
		}
		else {
			return null;
		}
	}

	/**************
	 * Validation
	 **************/
	private boolean xRangeValid(int x) {
		return x < this.xCellNum && x >= 0;
	}

	private boolean yRangeValid(int y) {
		return y < this.yCellNum && y >= 0;
	}

	private boolean xyRangeValid(int x, int y) {
		return xRangeValid(x) && yRangeValid(y);
	}

}
