/*
 * ConsecutiveExecuteComponent.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.consecutiveexecuter;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

import org.boxed_economy.besp.container.command.ImportWorldCommand;
import org.boxed_economy.besp.container.command.LimitedTimeRunCommand;
import org.boxed_economy.besp.model.SimulationStateEvent;
import org.boxed_economy.besp.model.SimulationStateListener;
import org.boxed_economy.besp.model.fmfw.World;
import org.boxed_economy.besp.presentation.guifw.AbstractInternalFrameComponent;
import org.boxed_economy.components.stepclock.StepLimitedTimeRunSetting;

/**
 * @author macchan
 * @version $Id: ConsecutiveExecuteComponent.java,v 1.1 2004/03/21 12:07:48 macchan Exp $
 */
public abstract class ConsecutiveExecuteComponent
	extends AbstractInternalFrameComponent
	implements SimulationStateListener {

	protected JLabel labelName = new JLabel();
	protected JLabel labelStatus = new JLabel();
	protected JButton buttonRun = new JButton();

	private ConsecutiveExecuteThread thread = null;

	/****************************
	 * 
	 ****************************/

	public final void initialize() {
		this.initializeComponents();
		this.initializeThread();
	}

	public final void terminate() {
	}

	private void initializeComponents() {
		this.labelName.setText(this.getTitleName());

		this.buttonRun.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				thread.doTransitition();
			}
		});

		//zu
		JPanel north = new JPanel();
		JPanel center = new JPanel();
		JPanel south = new JPanel();
		this.getContentPane().add(north, BorderLayout.NORTH);
		this.getContentPane().add(center, BorderLayout.CENTER);
		this.getContentPane().add(south, BorderLayout.SOUTH);
		north.add(this.labelName);
		center.add(this.buttonRun);
		south.add(this.labelStatus);
	}

	private void initializeThread() {
		this.thread = new ConsecutiveExecuteThread(this);
	}

	/****************************
	 * I[o[Chׂ
	 ****************************/

	protected abstract String getTitleName();

	protected abstract void run() throws InterruptedException;

	/****************************
	 * Xe[^X\p
	 ****************************/

	protected void showStatusMessage(String message) {
		this.labelStatus.setText(message);
	}

	/****************************
	 * Worldsp
	 ****************************/

	protected final void executeWorld(Class clazz, long step) {
		try {
			new ImportWorldCommand(
				this.getPresentationContainer().getContainer(),
				clazz)
				.execute();
		} catch (Exception ex) {
			this.getPresentationContainer().showError(
				"Error in Consecutive Execute",
				ex);
		}
		executeWorld(step);
	}

	protected final void executeWorld(World world, long step) {
		this.getPresentationContainer().getModelContainer().setModel(world);
		executeWorld(step);
	}

	private final void executeWorld(long step) {
		try {

			StepLimitedTimeRunSetting newSetting =
				new StepLimitedTimeRunSetting(step);

			this
				.getPresentationContainer()
				.getModelContainer()
				.setLimitedRunSetting(
				newSetting);

			new LimitedTimeRunCommand(
				this.getPresentationContainer().getContainer())
				.execute();
			synchronized (this) {
				this.wait();
			}
		} catch (Exception ex) {
			this.getPresentationContainer().showError(
				"Error in Consecutive Execute",
				ex);
		}
	}

	/****************************
	 * SimulationListener̎
	 ****************************/

	/**
	 * @see org.boxed_economy.besp.model.SimulationStateListener#simulationStarted(SimulationStateEvent)
	 */
	public void simulationStarted(SimulationStateEvent ev) {
	}

	/**
	 * @see org.boxed_economy.besp.model.SimulationStateListener#simulationStopped(SimulationStateEvent)
	 */
	public synchronized void simulationStopped(SimulationStateEvent ev) {
		this.notifyAll();
	}

	/**
	 * @see org.boxed_economy.besp.model.SimulationStateListener#simulationStopping(SimulationStateEvent)
	 */
	public void simulationStopping(SimulationStateEvent ev) {
	}

}
